/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.conversion.string.basic;

import cn.featherfly.common.lang.Strings;
import cn.featherfly.common.lang.reflect.Type;
import cn.featherfly.conversion.ConversionException;
import cn.featherfly.conversion.string.basic.AbstractBasicConvertor;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;

public class LocalTimeConvertor
extends AbstractBasicConvertor<LocalTime, Type<LocalTime>> {
    private static final String DATE_TIME_FORMAT = "HH:mm:ss";
    private static final DateTimeFormatter DATE_TIME_PATTERN = DateTimeFormatter.ofPattern("HH:mm:ss");

    @Override
    protected String doToString(LocalTime value, Type<LocalTime> genericType) {
        if (value != null) {
            return value.format(DATE_TIME_PATTERN);
        }
        return "";
    }

    @Override
    protected LocalTime doToObject(String value, Type<LocalTime> genericType) {
        if (Strings.isNotBlank((String)value)) {
            value = value.trim();
            try {
                return LocalTime.parse(value, DATE_TIME_PATTERN);
            }
            catch (Exception e) {
                throw new ConversionException("#convert_failed_with_type", new Object[]{value, DATE_TIME_FORMAT, this.getSourceType().getName()});
            }
        }
        return null;
    }
}

