/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.conversion.string.basic;

import cn.featherfly.common.lang.Strings;
import cn.featherfly.common.lang.reflect.Type;
import cn.featherfly.conversion.ConversionException;
import cn.featherfly.conversion.string.basic.AbstractBasicConvertor;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;

public class LocalDateConvertor
extends AbstractBasicConvertor<LocalDate, Type<LocalDate>> {
    private static final String DATE_TIME_FORMAT = "yyyy-MM-dd";
    private static final DateTimeFormatter DATE_TIME_PATTERN = DateTimeFormatter.ofPattern("yyyy-MM-dd");

    @Override
    protected String doToString(LocalDate value, Type<LocalDate> genericType) {
        if (value != null) {
            return value.format(DATE_TIME_PATTERN);
        }
        return "";
    }

    @Override
    protected LocalDate doToObject(String value, Type<LocalDate> genericType) {
        if (Strings.isNotBlank((String)value)) {
            value = value.trim();
            try {
                return LocalDate.parse(value, DATE_TIME_PATTERN);
            }
            catch (Exception e) {
                throw new ConversionException("#convert_failed_with_type", new Object[]{value, DATE_TIME_FORMAT, this.getSourceType().getName()});
            }
        }
        return null;
    }
}

