/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.conversion.string.basic;

import cn.featherfly.common.lang.Lang;
import cn.featherfly.common.lang.Strings;
import cn.featherfly.common.lang.reflect.Type;
import cn.featherfly.conversion.ConversionException;
import cn.featherfly.conversion.string.basic.AbstractBasicConvertor;

public class EnumConvertor<T extends Enum<T>>
extends AbstractBasicConvertor<T, Type<T>> {
    @Override
    public Class<T> getSourceType() {
        return Enum.class;
    }

    @Override
    protected String doToString(T value, Type<T> genericType) {
        if (value != null) {
            return ((Enum)value).toString();
        }
        return "";
    }

    @Override
    protected T doToObject(String value, Type<T> genericType) {
        if (Strings.isNotBlank((String)value)) {
            try {
                Enum t = Lang.toEnum((Class)genericType.getType(), (Object)value);
                if (t == null) {
                    throw new ConversionException("#convert_failed", new Object[]{value, genericType.getType().getName()});
                }
                return (T)t;
            }
            catch (IllegalArgumentException e) {
                throw new ConversionException("#convert_failed", new Object[]{value, genericType.getType().getName()});
            }
        }
        return null;
    }
}

