/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.conversion.string.basic;

import cn.featherfly.common.lang.LogUtils;
import cn.featherfly.common.lang.Strings;
import cn.featherfly.common.lang.reflect.Type;
import cn.featherfly.conversion.ConversionException;
import cn.featherfly.conversion.string.basic.AbstractBasicConvertor;
import org.slf4j.Logger;

public class ClassConvertor
extends AbstractBasicConvertor<Class, Type<Class>> {
    @Override
    public Class<Class> getSourceType() {
        return Class.class;
    }

    @Override
    protected String doToString(Class value, Type<Class> genericType) {
        if (value != null) {
            return value.getName();
        }
        return "";
    }

    @Override
    protected Class doToObject(String value, Type<Class> genericType) {
        if (Strings.isNotBlank((String)value)) {
            try {
                return Class.forName(value);
            }
            catch (ClassNotFoundException e) {
                LogUtils.debug((Exception)e, (Logger)this.logger);
                throw new ConversionException("#class_not_found", new Object[]{value});
            }
        }
        return null;
    }
}

