/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.conversion.string.basic;

import cn.featherfly.common.lang.Strings;
import cn.featherfly.common.lang.reflect.Type;
import cn.featherfly.conversion.string.ToStringConvertor;
import cn.featherfly.conversion.string.basic.AbstractBasicConvertor;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public abstract class ArrayConvertor<A, G extends Type<A>, E, GT extends Type<E>>
extends AbstractBasicConvertor<A, G> {
    private ToStringConvertor<E> convertor;

    public ArrayConvertor(ToStringConvertor<E> convertor) {
        this.convertor = convertor;
    }

    @Override
    public String doToString(A value, G genericType) {
        Class<?> type;
        if (value != null && (type = value.getClass()).isArray()) {
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < Array.getLength(value); ++i) {
                result.append((String)this.convertor.sourceToTarget(Array.get(value, i), (Type)this.getArrayItemType(genericType))).append(",");
            }
            if (result.length() > 0) {
                result.deleteCharAt(result.length() - 1);
            }
            return result.toString();
        }
        return "";
    }

    @Override
    public A doToObject(String value, G genericType) {
        Class type = this.getSourceType();
        if (Strings.isNotBlank((String)value) && type != null) {
            String[] values = Strings.split((String)value, (String)",");
            List<String> valueList = Arrays.asList(values);
            Iterator<String> it = valueList.iterator();
            while (it.hasNext()) {
                String v = it.next();
                if (!StringUtils.isBlank((CharSequence)v)) continue;
                it.remove();
            }
            Object result = Array.newInstance(type.getComponentType(), valueList.size());
            for (int i = 0; i < valueList.size(); ++i) {
                String v = valueList.get(i).trim();
                Array.set(result, i, this.convertor.targetToSource(v, this.getArrayItemType(genericType)));
            }
            return (A)result;
        }
        return null;
    }

    protected abstract GT getArrayItemType(G var1);

    public ToStringConvertor<E> getConvertor() {
        return this.convertor;
    }
}

