/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.conversion.string;

import cn.featherfly.common.lang.ClassUtils;
import cn.featherfly.common.lang.reflect.Type;
import cn.featherfly.conversion.ConversionException;
import cn.featherfly.conversion.TypePolicys;
import cn.featherfly.conversion.string.ToStringConvertor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class ToStringConversionPolicy
implements Cloneable {
    private Map<Class<?>, ToStringConvertor<?>> conversions = new HashMap();
    private Map<Class<?>, ToStringConvertor<?>> conversions2 = new HashMap();

    public ToStringConversionPolicy() {
    }

    public ToStringConversionPolicy(ToStringConvertor<?> ... convertor) {
        this.addConvertors(convertor);
    }

    public <E> void add(ToStringConvertor<E> convertor) {
        if (this.conversions != null) {
            Class type = convertor.getSourceType();
            ToStringConvertor c = this.getConvertor(type);
            if (c != null) {
                throw new ConversionException("#type_with_muliti_convertor", new Object[]{type.getName(), convertor.getClass().getName(), c.getClass().getName()});
            }
            if (convertor.getPolicy() == TypePolicys.CLASS) {
                this.conversions.put(type, convertor);
            } else {
                this.conversions2.put(type, convertor);
            }
        }
    }

    public void put(ToStringConvertor<?> convertor) {
        if (this.conversions != null) {
            Class type = convertor.getSourceType();
            this.conversions.put(type, convertor);
        }
    }

    public void add(ToStringConversionPolicy conversionPolicy) {
        if (conversionPolicy != null) {
            for (ToStringConvertor<?> convertor : conversionPolicy.getConvertors()) {
                this.add(convertor);
            }
        }
    }

    public void put(ToStringConversionPolicy conversionPolicy) {
        if (conversionPolicy != null) {
            for (ToStringConvertor<?> convertor : conversionPolicy.getConvertors()) {
                this.put(convertor);
            }
        }
    }

    public void put(ToStringConvertor<?> ... convertors) {
        if (convertors != null) {
            for (ToStringConvertor<?> convertor : convertors) {
                this.put(convertor);
            }
        }
    }

    public void addConvertors(ToStringConvertor<?> ... convertors) {
        if (convertors != null) {
            for (ToStringConvertor<?> convertor : convertors) {
                this.add(convertor);
            }
        }
    }

    public void addConvertors(Collection<ToStringConvertor<?>> convertors) {
        if (convertors != null) {
            for (ToStringConvertor<?> convertor : convertors) {
                this.add(convertor);
            }
        }
    }

    public boolean hasConvertor(Class<?> type) {
        return this.conversions.containsKey(type);
    }

    public <E> ToStringConvertor<E> getConvertor(Type<E> type) {
        return this.getConvertor(type.getType());
    }

    private <E> ToStringConvertor<E> getConvertor(Class<E> type) {
        ToStringConvertor<?> convertor = this.conversions.get(type);
        if (convertor == null && type.isEnum()) {
            convertor = this.conversions.get(Enum.class);
        }
        if (convertor != null) {
            return convertor;
        }
        for (Map.Entry<Class<?>, ToStringConvertor<?>> entry : this.conversions2.entrySet()) {
            if (!ClassUtils.isParent(entry.getKey(), type)) continue;
            return entry.getValue();
        }
        return null;
    }

    public Collection<ToStringConvertor<?>> getConvertors() {
        return new ArrayList(this.conversions.values());
    }

    public ToStringConversionPolicy clone() {
        ToStringConversionPolicy cp = new ToStringConversionPolicy();
        cp.addConvertors(new ArrayList(this.conversions.values()));
        cp.addConvertors(new ArrayList(this.conversions2.values()));
        return cp;
    }
}

