/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.conversion.string;

import cn.featherfly.common.bean.BeanProperty;
import cn.featherfly.common.bean.BeanUtils;
import cn.featherfly.common.lang.reflect.Type;
import cn.featherfly.conversion.ConversionException;
import cn.featherfly.conversion.Convertor;
import cn.featherfly.conversion.annotation.Assign;
import cn.featherfly.conversion.string.AbstractToStringConversion;
import cn.featherfly.conversion.string.ToStringConversionPolicy;
import cn.featherfly.conversion.string.ToStringConvertor;
import java.util.HashMap;
import java.util.Map;

public class ToStringBeanPropertyConversion
extends AbstractToStringConversion {
    private static final Map<Class<? extends ToStringConvertor<?>>, ToStringConvertor<?>> ASSIGN_CONVERSIONS = new HashMap();
    private boolean assignable = true;

    public ToStringBeanPropertyConversion() {
    }

    public ToStringBeanPropertyConversion(ToStringConversionPolicy conversionPolicy) {
        super(conversionPolicy);
    }

    public <E, G extends Type<E>> String sourceToTarget(E value, G genericType) {
        if (genericType instanceof BeanProperty) {
            return this.sourceToTarget(value, (BeanProperty)genericType);
        }
        throw new ConversionException("#type_with_muliti_convertor", new Object[]{this.getClass().getName(), genericType.getClass().getName()});
    }

    public <E> String sourceToTarget(E value, BeanProperty<E> beanProperty) {
        Assign assign = (Assign)beanProperty.getAnnotation(Assign.class);
        if (assign != null && this.assignable) {
            this.logger.debug("\u7c7b {} \u7684\u5c5e\u6027 {} \u6307\u5b9a\u4e86\u8f6c\u6362\u5668{} \u4f7f\u7528\u8be5\u8f6c\u6362\u5668\u8fdb\u884c\u8f6c\u6362", new Object[]{beanProperty.getOwnerType().getName(), beanProperty.getName(), assign.conversion().getClass().getName()});
            Class<? extends Convertor<?, ?>> ct = assign.conversion();
            return this.getAssignConvertor(ct, beanProperty).sourceToTarget((Object)value, (Type)beanProperty);
        }
        this.check();
        return this.getConvertor(beanProperty).sourceToTarget((Object)value, (Type)beanProperty);
    }

    public <E, G extends Type<E>> E targetToSource(String value, G genericType) {
        if (genericType instanceof BeanProperty) {
            return this.targetToSource(value, (BeanProperty)genericType);
        }
        throw new ConversionException("#type_with_muliti_convertor", new Object[]{this.getClass().getName(), genericType.getClass().getName()});
    }

    public <E> E targetToSource(String value, BeanProperty<E> beanProperty) {
        Assign assign = (Assign)beanProperty.getAnnotation(Assign.class);
        if (assign != null && this.assignable) {
            this.logger.debug("\u7c7b {} \u7684\u5c5e\u6027 {} \u6307\u5b9a\u4e86\u8f6c\u6362\u5668{} \u4f7f\u7528\u8be5\u8f6c\u6362\u5668\u8fdb\u884c\u8f6c\u6362", new Object[]{beanProperty.getOwnerType().getName(), beanProperty.getName(), assign.conversion().getClass().getName()});
            Class<? extends Convertor<?, ?>> ct = assign.conversion();
            return this.getAssignConvertor(ct, beanProperty).targetToSource(value, beanProperty);
        }
        this.check();
        return this.getConvertor(beanProperty).targetToSource(value, beanProperty);
    }

    private <E> ToStringConvertor<E> getAssignConvertor(Class<ToStringConvertor<E>> conversionType, BeanProperty<?> beanProperty) {
        ToStringConvertor conversion = ASSIGN_CONVERSIONS.get(conversionType);
        if (conversion == null && (conversion = (ToStringConvertor)BeanUtils.instantiateClass(conversionType)).getSourceType() != beanProperty.getType()) {
            throw new ConversionException("#type_with_error_convertor", new Object[]{beanProperty.getOwnerType().getName(), beanProperty.getName(), beanProperty.getType().getName(), conversionType.getName(), conversion.getSourceType().getName()});
        }
        return conversion;
    }

    public boolean isAssignable() {
        return this.assignable;
    }

    public void setAssignable(boolean assignable) {
        this.assignable = assignable;
    }
}

