/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.conversion.string;

import cn.featherfly.common.lang.reflect.Type;
import cn.featherfly.conversion.ConversionException;
import cn.featherfly.conversion.string.ToStringConversion;
import cn.featherfly.conversion.string.ToStringConversionPolicy;
import cn.featherfly.conversion.string.ToStringConversionPolicys;
import cn.featherfly.conversion.string.ToStringConvertor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractToStringConversion
implements ToStringConversion {
    private ToStringConversionPolicy conversionPolicy;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    public AbstractToStringConversion() {
        this(ToStringConversionPolicys.getBasicConversionPolicy());
    }

    public AbstractToStringConversion(ToStringConversionPolicy conversionPolicy) {
        this.conversionPolicy = conversionPolicy;
    }

    protected void check() {
        if (this.conversionPolicy == null) {
            throw new ConversionException("#no_policy");
        }
    }

    protected <E> ToStringConvertor<E> getConvertor(Type<E> type) {
        ToStringConvertor<E> convertor = this.conversionPolicy.getConvertor(type);
        if (convertor == null) {
            throw new ConversionException("#no_convertor_with_type", new Object[]{type.getType().getName()});
        }
        return convertor;
    }

    public ToStringConversionPolicy getConversionPolicy() {
        return this.conversionPolicy;
    }

    public void setConversionPolicy(ToStringConversionPolicy conversionPolicy) {
        this.conversionPolicy = conversionPolicy;
    }
}

