/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.conversion.parse;

import cn.featherfly.common.lang.Strings;
import cn.featherfly.common.lang.reflect.Type;
import cn.featherfly.conversion.parse.JacksonParser;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;

public abstract class YamlParser<G extends Type<?>>
extends JacksonParser<G> {
    public static final String PROTOCOL = "yaml";

    public YamlParser() {
        super(new ObjectMapper((JsonFactory)new YAMLFactory()));
    }

    @Override
    protected JacksonParser.Content getContent(String content) {
        JacksonParser.Content objContent = new JacksonParser.Content();
        String className = null;
        String yamlContent = null;
        int index = content.indexOf("#{");
        if (index == -1) {
            index = content.indexOf("#[");
            objContent.isMulty = index != -1;
        }
        content = content.trim();
        if (index != -1) {
            className = StringUtils.substring((String)content, (int)0, (int)index);
            yamlContent = StringUtils.substring((String)content, (int)(index + 3), (int)(content.length() - 1));
        } else {
            yamlContent = content;
        }
        objContent.className = Strings.trim((String)className);
        objContent.content = this.trimContent(yamlContent);
        return objContent;
    }

    private String trimContent(String content) {
        String result = "";
        String[] lines = content.split("\n");
        ArrayList<String> newLines = new ArrayList<String>();
        for (String line : lines) {
            if (!Strings.isNotBlank((String)line)) continue;
            newLines.add(line);
        }
        String firstLine = (String)newLines.get(0);
        int first = firstLine.length() - Strings.trimStart((String)firstLine).length();
        for (String line : newLines) {
            result = result + line.substring(first) + "\n";
        }
        return result.trim();
    }

    @Override
    public String getProtocol() {
        return PROTOCOL;
    }
}

