/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.conversion.parse;

import cn.featherfly.common.lang.Lang;
import cn.featherfly.common.lang.Strings;
import cn.featherfly.common.lang.reflect.Type;
import cn.featherfly.conversion.parse.ParseException;
import cn.featherfly.conversion.parse.Parser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class ParsePolity {
    private Map<String, Parser> parsers = new HashMap<String, Parser>();

    public <T> T parse(String resolve, Type<T> gt) {
        String protocol = null;
        if (Lang.isNotEmpty((String)resolve)) {
            protocol = this.getProtocol(resolve);
        }
        if (Lang.isEmpty(protocol)) {
            return null;
        }
        String content = this.getContent(resolve);
        for (Parser parser : this.parsers.values()) {
            if (!protocol.equals(parser.getProtocol())) continue;
            return parser.parse(content, gt);
        }
        return null;
    }

    public boolean canParse(String resolve) {
        for (String protocol : this.parsers.keySet()) {
            if (!resolve.startsWith(protocol + ":")) continue;
            return true;
        }
        return false;
    }

    public void register(Collection<Parser> parsers) {
        if (Lang.isNotEmpty(parsers)) {
            for (Parser parser : parsers) {
                this.register(parser);
            }
        }
    }

    public void register(Parser ... parsers) {
        if (Lang.isNotEmpty((Object[])parsers)) {
            for (Parser parser : parsers) {
                this.register(parser);
            }
        }
    }

    public void register(Parser parser) {
        if (parser != null) {
            if (this.isRegister(parser)) {
                throw new ParseException(Strings.format((String)"\u534f\u8bae[{0}]\u5df2\u7ecf\u88ab[{1}]\u6ce8\u518c", (Object[])new Object[]{parser.getProtocol(), this.getParser(parser.getProtocol()).getClass().getName()}));
            }
            this.parsers.put(parser.getProtocol(), parser);
        }
    }

    public void unregister(String protocol) {
        this.parsers.remove(protocol);
    }

    public void unregister(Parser parser) {
        if (parser != null) {
            this.parsers.remove(parser.getProtocol());
        }
    }

    public Collection<String> getProtocols() {
        return new ArrayList<String>(this.parsers.keySet());
    }

    public Collection<Parser> getParsers() {
        return new ArrayList<Parser>(this.parsers.values());
    }

    public boolean isRegister(String protocol) {
        return this.parsers.containsKey(protocol);
    }

    public boolean isRegister(Parser parser) {
        return this.isRegister(parser.getProtocol());
    }

    public Parser getParser(String protocol) {
        return this.parsers.get(protocol);
    }

    protected String getProtocol(String resolve) {
        if (Lang.isEmpty((String)resolve)) {
            return null;
        }
        int index = resolve.indexOf(58);
        if (index > 0) {
            return resolve.substring(0, index);
        }
        return null;
    }

    protected String getContent(String resolve) {
        if (Lang.isEmpty((String)resolve)) {
            return null;
        }
        int index = resolve.indexOf(58);
        if (index > 0) {
            return resolve.substring(index + 1);
        }
        return null;
    }
}

