/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.conversion.parse;

import cn.featherfly.common.lang.Lang;
import cn.featherfly.common.lang.Strings;
import cn.featherfly.common.lang.reflect.Type;
import cn.featherfly.conversion.parse.AbstractIterableParser;
import cn.featherfly.conversion.parse.ParseException;

public class ClassParser<G extends Type<?>>
extends AbstractIterableParser<G> {
    public static final String PROTOCOL = "class";

    @Override
    protected <T> T doParseContent(String content, G to) {
        if (Lang.isEmpty((String)content)) {
            return null;
        }
        try {
            return (T)Class.forName(Strings.trim((String)content)).newInstance();
        }
        catch (Exception e) {
            throw new ParseException(e);
        }
    }

    @Override
    protected boolean supportFor(Type<?> to) {
        return true;
    }

    @Override
    public String getProtocol() {
        return PROTOCOL;
    }
}

