/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.conversion.convertors;

import cn.featherfly.common.bean.BeanProperty;
import cn.featherfly.common.lang.ClassUtils;
import cn.featherfly.common.lang.reflect.ClassType;
import cn.featherfly.common.lang.reflect.Type;
import cn.featherfly.conversion.ConversionException;
import cn.featherfly.conversion.Convertor;
import cn.featherfly.conversion.TypePolicys;
import cn.featherfly.conversion.convertors.AbstractConvertor;
import cn.featherfly.conversion.convertors.Proxy;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public abstract class OptionalConvertor<T>
extends AbstractConvertor<Optional, T, Type<Optional>> {
    private Map<Class<?>, Convertor<?, T>> convertors = new HashMap();

    public OptionalConvertor() {
        this(null);
    }

    public OptionalConvertor(Collection<Convertor<?, T>> convertors) {
        this.setPolicy(TypePolicys.INSTANCE);
        this.setTargetType(ClassUtils.getSuperClassGenericType(this.getClass()));
        this.setSourceType(Optional.class);
        this.addConvertors(convertors);
    }

    public void setConvertors(Collection<Convertor<?, T>> convertors) {
        this.convertors.clear();
        this.addConvertors(convertors);
    }

    public void addConvertor(Convertor convertors) {
        if (convertors != null) {
            this.convertors.put(convertors.getSourceType(), convertors);
        }
    }

    public void addConvertors(Collection<Convertor<?, T>> convertors) {
        if (convertors != null) {
            for (Convertor<?, T> c : convertors) {
                this.convertors.put(c.getSourceType(), c);
            }
        }
    }

    @Override
    protected boolean supportFor(Type<Optional> generecType) {
        return generecType != null && generecType.getClass() == BeanProperty.class;
    }

    @Override
    protected T doSourceToTarget(Optional source, Type<Optional> genericType) {
        if (source != null && source.isPresent()) {
            Class<?> type = source.get().getClass();
            Convertor c = this.getConvertor(type);
            return c.sourceToTarget(source.get(), new ClassType(type));
        }
        return null;
    }

    @Override
    protected Optional doTargetToSource(T target, Type<Optional> genericType) {
        if (genericType instanceof BeanProperty) {
            BeanProperty bp = (BeanProperty)genericType;
            Class type = bp.getType();
            Convertor c = this.getConvertor(type);
            return Optional.of(c.targetToSource(target, new Proxy(bp, type)));
        }
        return null;
    }

    protected Convertor getConvertor(Class<?> type) {
        Convertor<?, T> convertor = this.convertors.get(type);
        if (convertor == null) {
            throw new ConversionException("#no_convertor_with_type", new Object[]{type.getName()});
        }
        return convertor;
    }
}

