/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.conversion.convertors;

import cn.featherfly.common.lang.reflect.Type;
import cn.featherfly.conversion.Convertor;
import cn.featherfly.conversion.TypePolicys;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConvertor<S, T, G extends Type<S>>
implements Convertor<S, T> {
    private Class<S> sourceType;
    private Class<T> targetType;
    private TypePolicys policy = TypePolicys.CLASS;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    public AbstractConvertor() {
    }

    public AbstractConvertor(Class<S> sourceType, Class<T> targetType, TypePolicys policy) {
        this.sourceType = sourceType;
        this.targetType = targetType;
        this.policy = policy;
    }

    protected abstract boolean supportFor(Type<S> var1);

    protected abstract T doSourceToTarget(S var1, G var2);

    protected abstract S doTargetToSource(T var1, G var2);

    @Override
    public <GT extends Type<S>> T sourceToTarget(S value, GT genericType) {
        if (this.supportFor(genericType)) {
            return this.doSourceToTarget(value, genericType);
        }
        return null;
    }

    @Override
    public <GT extends Type<S>> S targetToSource(T value, GT genericType) {
        if (this.supportFor(genericType)) {
            return this.doTargetToSource(value, genericType);
        }
        return null;
    }

    @Override
    public Class<S> getSourceType() {
        return this.sourceType;
    }

    public void setSourceType(Class<S> sourceType) {
        this.sourceType = sourceType;
    }

    @Override
    public Class<T> getTargetType() {
        return this.targetType;
    }

    public void setTargetType(Class<T> targetType) {
        this.targetType = targetType;
    }

    public TypePolicys getPolicy() {
        return this.policy;
    }

    public void setPolicy(TypePolicys policy) {
        this.policy = policy;
    }
}

