/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.conversion.core.format;

import cn.featherfly.common.lang.LangUtils;
import cn.featherfly.common.lang.LogUtils;
import cn.featherfly.common.lang.NumberUtils;
import cn.featherfly.common.lang.StringUtils;
import cn.featherfly.conversion.core.ConversionException;
import cn.featherfly.conversion.core.basic.NumberConvertor;
import cn.featherfly.conversion.core.format.FormatConvertor;
import cn.featherfly.conversion.core.format.FormatType;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.List;
import org.slf4j.Logger;

public class NumberFormatConvertor<T extends Number>
extends FormatConvertor<T> {
    public NumberFormatConvertor(NumberConvertor<T> convertor) {
        super(convertor);
    }

    @Override
    protected String formatToString(T value, FormatType<T> genericType) {
        if (genericType != null && value != null && StringUtils.isNotBlank((String)genericType.getFormat())) {
            DecimalFormat df = new DecimalFormat(genericType.getFormat());
            return df.format(value);
        }
        return null;
    }

    @Override
    protected T formatToObject(String value, FormatType<T> genericType) {
        if (genericType != null && value != null && LangUtils.isNotEmpty(genericType.getFormats())) {
            List<String> formats = genericType.getFormats();
            for (String format : formats) {
                DecimalFormat df = new DecimalFormat(format);
                try {
                    return (T)NumberUtils.value((Number)df.parse(value), this.getType());
                }
                catch (ParseException e) {
                    LogUtils.debug((Exception)e, (Logger)this.logger);
                }
            }
            throw new ConversionException("#convert_failed_with_type", new Object[]{value, formats, this.getType().getName()});
        }
        return null;
    }
}

