/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.conversion.core.basic;

import cn.featherfly.common.lang.GenericType;
import cn.featherfly.common.lang.StringUtils;
import cn.featherfly.conversion.core.ConversionException;
import cn.featherfly.conversion.core.basic.AbstractBasicConvertor;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

public class LocalDateTimeConvertor
extends AbstractBasicConvertor<LocalDateTime, GenericType<LocalDateTime>> {
    private static final String DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final DateTimeFormatter DATE_TIME_PATTERN = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    @Override
    protected String doToString(LocalDateTime value, GenericType<LocalDateTime> genericType) {
        if (value != null) {
            return value.format(DATE_TIME_PATTERN);
        }
        return "";
    }

    @Override
    protected LocalDateTime doToObject(String value, GenericType<LocalDateTime> genericType) {
        if (StringUtils.isNotBlank((String)value)) {
            value = value.trim();
            try {
                return LocalDateTime.parse(value, DATE_TIME_PATTERN);
            }
            catch (Exception e) {
                throw new ConversionException("#convert_failed_with_type", new Object[]{value, DATE_TIME_FORMAT, this.getType().getName()});
            }
        }
        return null;
    }
}

