/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.conversion.core;

import cn.featherfly.conversion.core.ConversionException;
import cn.featherfly.conversion.core.Convertor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class ConversionPolicy
implements Cloneable {
    private Map<Class<?>, Convertor<?>> conversions = new HashMap();

    public ConversionPolicy() {
    }

    public ConversionPolicy(Convertor<?> ... convertor) {
        this.addConvertors(convertor);
    }

    public void add(Convertor<?> convertor) {
        if (this.conversions != null) {
            Class<?> type = convertor.getType();
            Convertor<?> c = this.getConvertor(type);
            if (c != null) {
                throw new ConversionException("#type_with_muliti_convertor", new Object[]{type.getName(), convertor.getClass().getName(), c.getClass().getName()});
            }
            this.conversions.put(type, convertor);
        }
    }

    public void put(Convertor<?> convertor) {
        if (this.conversions != null) {
            Class<?> type = convertor.getType();
            this.conversions.put(type, convertor);
        }
    }

    public void add(ConversionPolicy conversionPolicy) {
        if (conversionPolicy != null) {
            for (Convertor<?> convertor : conversionPolicy.getConvertors()) {
                this.add(convertor);
            }
        }
    }

    public void put(ConversionPolicy conversionPolicy) {
        if (conversionPolicy != null) {
            for (Convertor<?> convertor : conversionPolicy.getConvertors()) {
                this.put(convertor);
            }
        }
    }

    public void put(Convertor<?> ... convertors) {
        if (convertors != null) {
            for (Convertor<?> convertor : convertors) {
                this.put(convertor);
            }
        }
    }

    public void addConvertors(Convertor<?> ... convertors) {
        if (convertors != null) {
            for (Convertor<?> convertor : convertors) {
                this.add(convertor);
            }
        }
    }

    public void addConvertors(Collection<Convertor<?>> convertors) {
        if (convertors != null) {
            for (Convertor<?> convertor : convertors) {
                this.add(convertor);
            }
        }
    }

    public boolean hasConvertor(Class<?> type) {
        return this.conversions.containsKey(type);
    }

    public Convertor<?> getConvertor(Class<?> type) {
        Convertor<?> conversion = this.conversions.get(type);
        if (conversion == null && type.isEnum()) {
            conversion = this.conversions.get(Enum.class);
        }
        return conversion;
    }

    public Collection<Convertor<?>> getConvertors() {
        return new ArrayList(this.conversions.values());
    }

    public ConversionPolicy clone() {
        ConversionPolicy cp = new ConversionPolicy();
        cp.addConvertors(new ArrayList(this.conversions.values()));
        return cp;
    }
}

