/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.conversion.core;

import cn.featherfly.common.bean.BeanProperty;
import cn.featherfly.common.bean.BeanUtils;
import cn.featherfly.common.lang.ClassUtils;
import cn.featherfly.conversion.core.AbstractConversion;
import cn.featherfly.conversion.core.ConversionException;
import cn.featherfly.conversion.core.ConversionPolicy;
import cn.featherfly.conversion.core.Convertor;
import cn.featherfly.conversion.core.annotation.Assign;
import java.util.HashMap;
import java.util.Map;

public class BeanPropertyConversion
extends AbstractConversion<BeanProperty<?>> {
    private static final Map<Class<? extends Convertor<?>>, Convertor<?>> ASSIGN_CONVERSIONS = new HashMap();
    private boolean assignable = true;

    public BeanPropertyConversion() {
    }

    public BeanPropertyConversion(ConversionPolicy conversionPolicy) {
        super(conversionPolicy);
    }

    @Override
    public <E> String toString(E value, BeanProperty<?> beanProperty) {
        Assign assign = (Assign)beanProperty.getAnnotation(Assign.class);
        if (assign != null && this.assignable) {
            this.logger.debug("\u7c7b {} \u7684\u5c5e\u6027 {} \u6307\u5b9a\u4e86\u8f6c\u6362\u5668{} \u4f7f\u7528\u8be5\u8f6c\u6362\u5668\u8fdb\u884c\u8f6c\u6362", new Object[]{beanProperty.getOwnerType().getName(), beanProperty.getName(), assign.conversion().getClass().getName()});
            Class<Convertor<E>> ct = assign.conversion();
            return this.getAssignConvertor(ct, beanProperty).toString(value, beanProperty);
        }
        this.check();
        return this.getConvertor(ClassUtils.castGenericType((Class)beanProperty.getType(), value)).toString(value, beanProperty);
    }

    @Override
    public <E> E toObject(String value, BeanProperty<?> beanProperty) {
        Assign assign = (Assign)beanProperty.getAnnotation(Assign.class);
        if (assign != null && this.assignable) {
            this.logger.debug("\u7c7b {} \u7684\u5c5e\u6027 {} \u6307\u5b9a\u4e86\u8f6c\u6362\u5668{} \u4f7f\u7528\u8be5\u8f6c\u6362\u5668\u8fdb\u884c\u8f6c\u6362", new Object[]{beanProperty.getOwnerType().getName(), beanProperty.getName(), assign.conversion().getClass().getName()});
            Class<Convertor<E>> ct = assign.conversion();
            return this.getAssignConvertor(ct, beanProperty).toObject(value, beanProperty);
        }
        this.check();
        return this.getConvertor(beanProperty.getType()).toObject(value, beanProperty);
    }

    private <E> Convertor<E> getAssignConvertor(Class<Convertor<E>> conversionType, BeanProperty<?> beanProperty) {
        Convertor conversion = ASSIGN_CONVERSIONS.get(conversionType);
        if (conversion == null && (conversion = (Convertor)BeanUtils.instantiateClass(conversionType)).getType() != beanProperty.getType()) {
            throw new ConversionException("#type_with_error_convertor", new Object[]{beanProperty.getOwnerType().getName(), beanProperty.getName(), beanProperty.getType().getName(), conversionType.getName(), conversion.getType().getName()});
        }
        return conversion;
    }

    public boolean isAssignable() {
        return this.assignable;
    }

    public void setAssignable(boolean assignable) {
        this.assignable = assignable;
    }
}

