/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.conversion.core;

import cn.featherfly.common.lang.GenericType;
import cn.featherfly.conversion.core.Conversion;
import cn.featherfly.conversion.core.ConversionException;
import cn.featherfly.conversion.core.ConversionPolicy;
import cn.featherfly.conversion.core.ConversionPolicys;
import cn.featherfly.conversion.core.Convertor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConversion<G extends GenericType<?>>
implements Conversion<G> {
    private ConversionPolicy conversionPolicy;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    public AbstractConversion() {
        this(ConversionPolicys.getBasicConversionPolicy());
    }

    public AbstractConversion(ConversionPolicy conversionPolicy) {
        this.conversionPolicy = conversionPolicy;
    }

    protected void check() {
        if (this.conversionPolicy == null) {
            throw new ConversionException("#no_policy");
        }
    }

    protected <E> Convertor<E> getConvertor(Class<E> type) {
        Convertor<?> convertor = this.conversionPolicy.getConvertor(type);
        if (convertor == null) {
            throw new ConversionException("#no_convertor_with_type", new Object[]{type.getName()});
        }
        return convertor;
    }

    public ConversionPolicy getConversionPolicy() {
        return this.conversionPolicy;
    }

    public void setConversionPolicy(ConversionPolicy conversionPolicy) {
        this.conversionPolicy = conversionPolicy;
    }
}

