/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.conversion.parse;

import cn.featherfly.common.lang.GenericType;
import cn.featherfly.common.lang.LangUtils;
import cn.featherfly.common.lang.StringUtils;
import cn.featherfly.conversion.parse.AbstractIterableParser;
import cn.featherfly.conversion.parse.ParseException;

public class ClassParser<G extends GenericType<?>>
extends AbstractIterableParser<G> {
    public static final String PROTOCOL = "class";

    @Override
    protected <T> T doParseContent(String content, G to) {
        if (LangUtils.isEmpty((String)content)) {
            return null;
        }
        try {
            return (T)Class.forName(StringUtils.trim((String)content)).newInstance();
        }
        catch (Exception e) {
            throw new ParseException(e);
        }
    }

    @Override
    protected boolean supportFor(GenericType<?> to) {
        return true;
    }

    @Override
    public String getProtocol() {
        return PROTOCOL;
    }
}

