/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.conversion.parse;

import cn.featherfly.common.lang.ClassUtils;
import cn.featherfly.common.lang.GenericType;
import cn.featherfly.common.lang.LangUtils;
import cn.featherfly.conversion.parse.AbstractIterableParser;
import cn.featherfly.conversion.parse.ParseException;

public class ClassMethodParser<G extends GenericType<?>>
extends AbstractIterableParser<G> {
    public static final String PROTOCOL = "method";

    @Override
    protected <T> T doParseContent(String content, G to) {
        if (LangUtils.isEmpty((String)content)) {
            return null;
        }
        String[] strs = this.parseContent(content);
        if (strs.length != 2) {
            throw new ParseException("format error " + content);
        }
        String className = strs[0];
        String methodName = strs[1];
        return (T)this.getValue(className, methodName);
    }

    private String[] parseContent(String str) {
        StringBuilder sb = new StringBuilder();
        boolean afterDot = false;
        boolean find = false;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (Character.isUpperCase(c) && afterDot) {
                find = true;
            }
            if (c == '.') {
                afterDot = true;
                if (find) {
                    return new String[]{sb.toString(), str.substring(i + 1)};
                }
            } else {
                afterDot = false;
            }
            sb.append(c);
        }
        return new String[]{sb.toString()};
    }

    private Object getValue(String className, String methodName) {
        try {
            return this.getValue(Class.forName(className), methodName);
        }
        catch (ClassNotFoundException e) {
            throw new ParseException(e);
        }
    }

    private Object getValue(Class<?> type, String methodName) {
        return ClassUtils.invokeMethod(type, (String)methodName);
    }

    @Override
    protected boolean supportFor(GenericType<?> to) {
        return true;
    }

    @Override
    public String getProtocol() {
        return PROTOCOL;
    }
}

