/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.conversion.parse;

import cn.featherfly.common.lang.ClassUtils;
import cn.featherfly.common.lang.CollectionUtils;
import cn.featherfly.common.lang.GenericType;
import cn.featherfly.common.lang.LangUtils;
import cn.featherfly.conversion.parse.AbstractParser;
import cn.featherfly.conversion.parse.ParseException;
import java.lang.reflect.Array;
import java.util.Collection;

public abstract class AbstractIterableParser<G extends GenericType<?>>
extends AbstractParser<G> {
    protected abstract <T> T doParseContent(String var1, G var2);

    @Override
    protected <T> T doParse(String content, G to) {
        if (LangUtils.isEmpty((String)content)) {
            return null;
        }
        try {
            String splitSign = ",";
            if (content.contains(splitSign) || this.isMultyType(to.getType())) {
                String[] contents = content.split(splitSign);
                if (to.getType().isArray()) {
                    Object array = Array.newInstance(to.getType(), contents.length);
                    for (int i = 0; i < contents.length; ++i) {
                        String c = contents[i].trim();
                        Array.set(array, i, this.doParseContent(c, to));
                    }
                    return (T)array;
                }
                if (ClassUtils.isParent(Collection.class, (Class)to.getType())) {
                    Collection collection = CollectionUtils.newInstance((Class)to.getType());
                    for (int i = 0; i < contents.length; ++i) {
                        String c = contents[i].trim();
                        collection.add(this.doParseContent(c, to));
                    }
                    return (T)collection;
                }
                throw new ParseException("\u76ee\u6807\u7c7b\u578b\u4e0d\u662fArray\u4e5f\u4e0d\u662fCollection,\u4f46\u662f\u8f6c\u6362\u503c\u5305\u542b\u534a\u89d2\u9017\u53f7\uff08,\uff09,\u65e0\u6cd5\u8fdb\u884c\u8f6c\u6362");
            }
            return this.doParseContent(content, to);
        }
        catch (Exception e) {
            throw new ParseException(e);
        }
    }

    protected boolean isMultyType(Class<?> type) {
        return type.isArray() || ClassUtils.isParent(Collection.class, type);
    }
}

