/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.conversion.core.format;

import cn.featherfly.common.lang.GenericType;
import cn.featherfly.conversion.core.AbstractConvertor;
import cn.featherfly.conversion.core.Convertor;
import cn.featherfly.conversion.core.format.FormatType;

public abstract class FormatConvertor<T>
extends AbstractConvertor<T, FormatType<T>> {
    private Convertor<T> convertor;

    public FormatConvertor(Convertor<T> convertor) {
        this.convertor = convertor;
    }

    @Override
    protected boolean supportFor(GenericType<T> generecType) {
        if (generecType == null) {
            return false;
        }
        return FormatType.class == generecType.getClass();
    }

    @Override
    protected String doToString(T value, FormatType<T> genericType) {
        String result = this.formatToString(value, genericType);
        if (result == null) {
            return this.convertor.toString(value, null);
        }
        return result;
    }

    @Override
    protected T doToObject(String value, FormatType<T> genericType) {
        T result = this.formatToObject(value, genericType);
        if (result == null) {
            return this.convertor.toObject(value, null);
        }
        return result;
    }

    public Convertor<T> getConvertor() {
        return this.convertor;
    }

    protected abstract String formatToString(T var1, FormatType<T> var2);

    protected abstract T formatToObject(String var1, FormatType<T> var2);
}

