/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.conversion.core.format;

import cn.featherfly.common.lang.LangUtils;
import cn.featherfly.common.lang.StringUtils;
import cn.featherfly.conversion.core.ConversionException;
import cn.featherfly.conversion.core.Convertor;
import cn.featherfly.conversion.core.format.FormatConvertor;
import cn.featherfly.conversion.core.format.FormatType;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

public abstract class AbstractSqlDateFormatConvertor<T extends Date>
extends FormatConvertor<T> {
    public AbstractSqlDateFormatConvertor(Convertor<T> convertor) {
        super(convertor);
    }

    protected abstract T convert(Date var1);

    @Override
    protected String formatToString(T value, FormatType<T> genericType) {
        if (genericType != null && StringUtils.isNotBlank((String)genericType.getFormat())) {
            SimpleDateFormat sdf = new SimpleDateFormat(genericType.getFormat());
            this.logger.debug("format {} to string with {}", (Object)this.getType().getName(), (Object)genericType.getFormat());
            return sdf.format((Date)value);
        }
        return null;
    }

    @Override
    protected T formatToObject(String value, FormatType<T> genericType) {
        if (genericType != null && LangUtils.isNotEmpty(genericType.getFormats())) {
            List<String> formats = genericType.getFormats();
            for (String format : formats) {
                SimpleDateFormat sdf = new SimpleDateFormat(format);
                try {
                    Date d = sdf.parse(value);
                    this.logger.debug("parse {} with format[{}] success", (Object)value, (Object)format);
                    return this.convert(d);
                }
                catch (ParseException e) {
                    this.logger.debug("parse {} with format[{}] error", (Object)value, (Object)format);
                }
            }
            throw new ConversionException("#convert_failed_with_type", new Object[]{value, formats, this.getType().getName()});
        }
        return null;
    }
}

