/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.conversion.core.format;

import cn.featherfly.common.lang.LangUtils;
import cn.featherfly.common.lang.StringUtils;
import cn.featherfly.conversion.core.ConversionException;
import cn.featherfly.conversion.core.Convertor;
import cn.featherfly.conversion.core.format.FormatConvertor;
import cn.featherfly.conversion.core.format.FormatType;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.util.List;

public abstract class AbstractLocalDateTimeFormatConvertor<T extends Temporal>
extends FormatConvertor<T> {
    public AbstractLocalDateTimeFormatConvertor(Convertor<T> convertor) {
        super(convertor);
    }

    protected abstract T convert(String var1, DateTimeFormatter var2);

    @Override
    protected String formatToString(T value, FormatType<T> genericType) {
        if (genericType != null && StringUtils.isNotBlank((String)genericType.getFormat())) {
            DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(genericType.getFormat());
            this.logger.debug("format {} to string with {}", (Object)this.getType().getName(), (Object)genericType.getFormat());
            return dateTimeFormatter.format((TemporalAccessor)value);
        }
        return null;
    }

    @Override
    protected T formatToObject(String value, FormatType<T> genericType) {
        if (genericType != null && LangUtils.isNotEmpty(genericType.getFormats())) {
            List<String> formats = genericType.getFormats();
            for (String format : formats) {
                DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(format);
                try {
                    T t = this.convert(value, dateTimeFormatter);
                    this.logger.debug("parse {} with format[{}] success", (Object)value, (Object)format);
                    return t;
                }
                catch (DateTimeParseException e) {
                    this.logger.debug("parse {} with format[{}] error", (Object)value, (Object)format);
                }
            }
            throw new ConversionException("#convert_failed_with_type", new Object[]{value, formats, this.getType().getName()});
        }
        return null;
    }
}

