/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.conversion.core.bp;

import cn.featherfly.common.bean.BeanProperty;
import cn.featherfly.common.lang.ArrayUtils;
import cn.featherfly.conversion.core.annotation.Format;
import cn.featherfly.conversion.core.bp.BeanPropertyConvertor;
import cn.featherfly.conversion.core.format.FormatConvertor;
import cn.featherfly.conversion.core.format.FormatType;

public class BeanPropertyFormatConvertor<T>
extends BeanPropertyConvertor<T> {
    private FormatConvertor<T> convertor;

    public BeanPropertyFormatConvertor(FormatConvertor<T> convertor) {
        this.convertor = convertor;
    }

    @Override
    protected String doToString(T value, BeanProperty<T> beanProperty) {
        FormatType formatType = new FormatType(this.getType());
        Format format = (Format)beanProperty.getAnnotation(Format.class);
        if (beanProperty != null && format != null) {
            formatType.setFormat(format.format());
            formatType.setFormats(ArrayUtils.toList((Object[])format.formats()));
        }
        return this.convertor.toString(value, formatType);
    }

    @Override
    protected T doToObject(String value, BeanProperty<T> beanProperty) {
        FormatType formatType = new FormatType(this.getType());
        Format format = (Format)beanProperty.getAnnotation(Format.class);
        if (beanProperty != null && format != null) {
            formatType.setFormat(format.format());
            formatType.setFormats(ArrayUtils.toList((Object[])format.formats()));
        }
        return this.convertor.toObject(value, formatType);
    }

    public FormatConvertor<T> getConvertor() {
        return this.convertor;
    }
}

