/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.conversion.core.basic;

import cn.featherfly.common.lang.GenericType;
import cn.featherfly.common.lang.StringUtils;
import cn.featherfly.conversion.core.ConversionException;
import cn.featherfly.conversion.core.basic.AbstractBasicConvertor;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;

public class LocalDateConvertor
extends AbstractBasicConvertor<LocalDate, GenericType<LocalDate>> {
    private static final String DATE_TIME_FORMAT = "yyyy-MM-dd";
    private static final DateTimeFormatter DATE_TIME_PATTERN = DateTimeFormatter.ofPattern("yyyy-MM-dd");

    @Override
    protected String doToString(LocalDate value, GenericType<LocalDate> genericType) {
        if (value != null) {
            return value.format(DATE_TIME_PATTERN);
        }
        return "";
    }

    @Override
    protected LocalDate doToObject(String value, GenericType<LocalDate> genericType) {
        if (StringUtils.isNotBlank((String)value)) {
            value = value.trim();
            try {
                return LocalDate.parse(value, DATE_TIME_PATTERN);
            }
            catch (Exception e) {
                throw new ConversionException("#convert_failed_with_type", new Object[]{value, DATE_TIME_FORMAT, this.getType().getName()});
            }
        }
        return null;
    }
}

