/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.conversion.core.basic;

import cn.featherfly.common.lang.GenericType;
import cn.featherfly.common.lang.LangUtils;
import cn.featherfly.common.lang.StringUtils;
import cn.featherfly.conversion.core.ConversionException;
import cn.featherfly.conversion.core.basic.AbstractBasicConvertor;

public class EnumConvertor<T extends Enum<T>>
extends AbstractBasicConvertor<T, GenericType<T>> {
    @Override
    public Class<T> getType() {
        return Enum.class;
    }

    @Override
    protected String doToString(T value, GenericType<T> genericType) {
        if (value != null) {
            return ((Enum)value).toString();
        }
        return "";
    }

    @Override
    protected T doToObject(String value, GenericType<T> genericType) {
        if (StringUtils.isNotBlank((String)value)) {
            try {
                Enum t = LangUtils.toEnum((Class)genericType.getType(), (Object)value);
                if (t == null) {
                    throw new ConversionException("#convert_failed", new Object[]{value, genericType.getType().getName()});
                }
                return (T)t;
            }
            catch (IllegalArgumentException e) {
                throw new ConversionException("#convert_failed", new Object[]{value, genericType.getType().getName()});
            }
        }
        return null;
    }
}

