/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.conversion.core.basic;

import cn.featherfly.common.lang.GenericType;
import cn.featherfly.common.lang.LogUtils;
import cn.featherfly.common.lang.StringUtils;
import cn.featherfly.conversion.core.ConversionException;
import cn.featherfly.conversion.core.basic.AbstractBasicConvertor;
import org.slf4j.Logger;

public class ClassConvertor
extends AbstractBasicConvertor<Class, GenericType<Class>> {
    @Override
    public Class<Class> getType() {
        return Class.class;
    }

    @Override
    protected String doToString(Class value, GenericType<Class> genericType) {
        if (value != null) {
            return value.getName();
        }
        return "";
    }

    @Override
    protected Class doToObject(String value, GenericType<Class> genericType) {
        if (StringUtils.isNotBlank((String)value)) {
            try {
                return Class.forName(value);
            }
            catch (ClassNotFoundException e) {
                LogUtils.debug((Exception)e, (Logger)this.logger);
                throw new ConversionException("#class_not_found", new Object[]{value});
            }
        }
        return null;
    }
}

