/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.conversion.core.basic;

import cn.featherfly.common.lang.GenericType;
import cn.featherfly.common.lang.StringUtils;
import cn.featherfly.conversion.core.Convertor;
import cn.featherfly.conversion.core.basic.AbstractBasicConvertor;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public abstract class ArrayConvertor<A, G extends GenericType<A>, E, GT extends GenericType<E>>
extends AbstractBasicConvertor<A, G> {
    private Convertor<E> convertor;

    public ArrayConvertor(Convertor<E> convertor) {
        this.convertor = convertor;
    }

    @Override
    public String doToString(A value, G genericType) {
        Class<?> type;
        if (value != null && (type = value.getClass()).isArray()) {
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < Array.getLength(value); ++i) {
                result.append(this.convertor.toString((E)Array.get(value, i), this.getArrayItemGenericType(genericType))).append(",");
            }
            if (result.length() > 0) {
                result.deleteCharAt(result.length() - 1);
            }
            return result.toString();
        }
        return "";
    }

    @Override
    public A doToObject(String value, G genericType) {
        Class type = this.getType();
        if (StringUtils.isNotBlank((String)value) && type != null) {
            String[] values = StringUtils.split((String)value, (String)",");
            List<String> valueList = Arrays.asList(values);
            Iterator<String> it = valueList.iterator();
            while (it.hasNext()) {
                String v = it.next();
                if (!StringUtils.isBlank((CharSequence)v)) continue;
                it.remove();
            }
            Object result = Array.newInstance(type.getComponentType(), valueList.size());
            for (int i = 0; i < valueList.size(); ++i) {
                String v = valueList.get(i).trim();
                Array.set(result, i, this.convertor.toObject(v, this.getArrayItemGenericType(genericType)));
            }
            return (A)result;
        }
        return null;
    }

    protected abstract GT getArrayItemGenericType(G var1);

    public Convertor<E> getConvertor() {
        return this.convertor;
    }
}

