/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.conversion.core.basic;

import cn.featherfly.common.lang.ArrayUtils;
import cn.featherfly.common.lang.GenericType;
import cn.featherfly.common.lang.LangUtils;
import cn.featherfly.common.lang.StringUtils;
import cn.featherfly.conversion.core.ConversionException;
import cn.featherfly.conversion.core.basic.AbstractBasicConvertor;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public abstract class AbstractDateConvertor<T extends Date>
extends AbstractBasicConvertor<T, GenericType<T>> {
    protected abstract String getFormat();

    protected abstract String[] getFormats();

    protected abstract T convert(Date var1);

    @Override
    protected String doToString(T value, GenericType<T> genericType) {
        if (value != null) {
            if (StringUtils.isNotBlank((String)this.getFormat())) {
                this.logger.debug("format {} to string with {}", (Object)this.getType().getName(), (Object)this.getFormat());
                SimpleDateFormat df = new SimpleDateFormat(this.getFormat());
                return df.format((Date)value);
            }
            this.logger.warn("there is no format, use value.toString()");
            ((Date)value).toString();
        }
        return "";
    }

    @Override
    protected T doToObject(String value, GenericType<T> genericType) {
        Object[] formats = this.getFormats();
        if (LangUtils.isEmpty((Object[])formats)) {
            this.logger.warn("there is no formats, can not parse {} to {}", (Object)value, (Object)this.getType().getName());
        } else if (StringUtils.isNotBlank((String)value)) {
            for (Object format : formats) {
                SimpleDateFormat sdf = new SimpleDateFormat((String)format);
                try {
                    Date d = sdf.parse(value);
                    this.logger.debug("parse {} with format[{}] success", (Object)value, format);
                    return this.convert(d);
                }
                catch (ParseException e) {
                    this.logger.debug("parse {} with format[{}] error", (Object)value, format);
                }
            }
            throw new ConversionException("#convert_failed_with_type", new Object[]{value, ArrayUtils.toString((Object[])formats), this.getType().getName()});
        }
        return null;
    }
}

