/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.conversion.core;

import cn.featherfly.common.lang.ClassUtils;
import cn.featherfly.common.lang.GenericType;
import cn.featherfly.conversion.core.Convertor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConvertor<T, G extends GenericType<T>>
implements Convertor<T> {
    private Class<T> type;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    public AbstractConvertor() {
        this.type = ClassUtils.getSuperClassGenricType(this.getClass());
    }

    protected abstract boolean supportFor(GenericType<T> var1);

    protected abstract String doToString(T var1, G var2);

    protected abstract T doToObject(String var1, G var2);

    @Override
    public <GT extends GenericType<T>> String toString(T value, GT genericType) {
        if (this.supportFor(genericType)) {
            return this.doToString(value, genericType);
        }
        return null;
    }

    @Override
    public <GT extends GenericType<T>> T toObject(String value, GT genericType) {
        if (this.supportFor(genericType)) {
            return this.doToObject(value, genericType);
        }
        return null;
    }

    @Override
    public Class<T> getType() {
        return this.type;
    }

    protected Class<T> getGenricType() {
        return this.type;
    }
}

