/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.compress.zip;

import cn.featherfly.common.compress.zip.ZipFile;
import cn.featherfly.common.lang.AssertIllegalArgument;
import java.io.File;
import java.io.IOException;

public final class ZipFileUtils {
    private ZipFileUtils() {
    }

    public static void decompress(File zipFile, String decompressDir) {
        AssertIllegalArgument.isNotNull((Object)zipFile, (String)"File zipFile\u4e0d\u80fd\u4e3a\u7a7a!");
        new ZipFile(zipFile).decompress(decompressDir).close();
    }

    public static void decompress(File zipFile, File decompressDir) {
        AssertIllegalArgument.isNotNull((Object)zipFile, (String)"File zipFile\u4e0d\u80fd\u4e3a\u7a7a!");
        new ZipFile(zipFile).decompress(decompressDir).close();
    }

    public static void decompress(File zipFile, File decompressDir, String encoding) {
        AssertIllegalArgument.isNotNull((Object)zipFile, (String)"File zipFile\u4e0d\u80fd\u4e3a\u7a7a!");
        new ZipFile(zipFile, encoding).decompress(decompressDir).close();
    }

    public static void decompress(File zipFile, String filePath, String decompressDir) throws IOException {
        AssertIllegalArgument.isNotNull((Object)zipFile, (String)"zipFile\u4e0d\u80fd\u4e3a\u7a7a!");
        new ZipFile(zipFile).decompress(filePath, decompressDir).close();
    }

    public static void decompress(File zipFile, String filePath, File decompressFile) {
        AssertIllegalArgument.isNotNull((Object)zipFile, (String)"zipFile\u4e0d\u80fd\u4e3a\u7a7a!");
        new ZipFile(zipFile).decompress(filePath, decompressFile).close();
    }

    public static void decompress(File zipFile, String filePath, String decompressDir, String fileName) {
        AssertIllegalArgument.isNotNull((Object)decompressDir, (String)"\u89e3\u538b\u7f29\u76ee\u5f55\u4e0d\u80fd\u4e3a\u7a7a!");
        AssertIllegalArgument.isNotNull((Object)fileName, (String)"\u89e3\u538b\u540e\u7684\u6587\u4ef6\u540d\u4e0d\u80fd\u4e3a\u7a7a!");
        ZipFileUtils.decompress(zipFile, filePath, new File(decompressDir + "/" + fileName));
    }

    public static ZipFile compress(File file, File target) {
        AssertIllegalArgument.isNotNull((Object)file, (String)"\u538b\u7f29\u4ee5\u540e\u7684\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a!");
        AssertIllegalArgument.isNotNull((Object)target, (String)"\u76ee\u6807\u6587\u4ef6\u6216\u6587\u4ef6\u5939\u4e0d\u80fd\u4e3a\u7a7a!");
        return ZipFile.compress(file, target);
    }

    public static ZipFile compress(File file, File target, String encoding) {
        AssertIllegalArgument.isNotNull((Object)file, (String)"\u538b\u7f29\u4ee5\u540e\u7684\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a!");
        AssertIllegalArgument.isNotNull((Object)target, (String)"\u76ee\u6807\u6587\u4ef6\u6216\u6587\u4ef6\u5939\u4e0d\u80fd\u4e3a\u7a7a!");
        AssertIllegalArgument.isNotNull((Object)encoding, (String)"\u538b\u7f29\u4f7f\u7528\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
        return ZipFile.compress(file, target, encoding);
    }

    public static ZipFile compressFile(File file, File ... files) {
        AssertIllegalArgument.isNotNull((Object)file, (String)"\u538b\u7f29\u4ee5\u540e\u7684\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a!");
        return ZipFile.compressFile(file, files);
    }

    public static ZipFile compressFile(File file, String encoding, File ... files) {
        AssertIllegalArgument.isNotNull((Object)file, (String)"\u538b\u7f29\u4ee5\u540e\u7684\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a!");
        return ZipFile.compressFile(file, encoding, files);
    }
}

