/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.compress.zip;

import cn.featherfly.common.compress.CompressException;
import cn.featherfly.common.lang.AssertIllegalArgument;
import cn.featherfly.common.lang.StringUtils;
import cn.featherfly.common.lang.UriUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipFile {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZipFile.class);
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static final int DEFAULT_BUFFER_SIZE = 1024;
    private File file;
    private org.apache.tools.zip.ZipFile zipFile;
    private int bufferSize = 1024;

    public ZipFile(File file) {
        this(file, DEFAULT_ENCODING);
    }

    public ZipFile(String name) throws IOException {
        this(new File(name));
    }

    public ZipFile(File file, String encoding) {
        try {
            this.file = file;
            this.zipFile = new org.apache.tools.zip.ZipFile(file, encoding);
        }
        catch (IOException e) {
            throw new CompressException(e);
        }
    }

    public ZipFile(String name, String encoding) {
        this(new File(name), encoding);
    }

    public ZipFile decompress(File decompressDir) {
        AssertIllegalArgument.isNotNull((Object)decompressDir, (String)"decompressDir\u4e0d\u80fd\u4e3a\u7a7a!");
        this.assertIsNotFile(decompressDir);
        LOGGER.debug("\u5f00\u59cb\u89e3\u538bZIP\u6587\u4ef6\uff1a{}", (Object)this.file.getAbsolutePath());
        try {
            Enumeration<ZipEntry> emu = this.getEntries();
            while (emu.hasMoreElements()) {
                File file;
                ZipEntry entry = emu.nextElement();
                String entryName = this.getEntryPath(entry);
                if (entry.isDirectory()) {
                    file = new File(decompressDir.getAbsolutePath() + "/" + entryName);
                    file.mkdirs();
                    continue;
                }
                file = new File(decompressDir.getAbsolutePath() + "/" + entryName);
                this.writeFile(this.zipFile.getInputStream(entry), file);
            }
        }
        catch (IOException e) {
            throw new CompressException(e);
        }
        LOGGER.debug("\u7ed3\u675f\u89e3\u538bZIP\u6587\u4ef6\uff1a{}", (Object)this.file.getAbsolutePath());
        return this;
    }

    public ZipFile decompress(String decompressDir) {
        AssertIllegalArgument.isNotEmpty((String)decompressDir, (String)"decompressDir\u4e0d\u80fd\u4e3a\u7a7a!");
        this.decompress(new File(decompressDir));
        return this;
    }

    public ZipFile decompress(String filePath, String decompressDir) throws IOException {
        AssertIllegalArgument.isNotEmpty((String)filePath, (String)"filePath\u4e0d\u80fd\u4e3a\u7a7a!");
        AssertIllegalArgument.isNotEmpty((String)decompressDir, (String)"decompressDir\u4e0d\u80fd\u4e3a\u7a7a!");
        File dir = new File(decompressDir);
        this.assertIsNotFile(dir);
        try {
            ZipEntry zipEntry = this.getEntry(filePath);
            if (zipEntry != null) {
                this.writeFile(this.getResourceAsStream(filePath), new File(decompressDir + "/" + this.getEntryFileName(zipEntry)));
            }
        }
        catch (IOException e) {
            throw new CompressException(e);
        }
        return this;
    }

    public ZipFile decompress(String filePath, File decompressFile) {
        AssertIllegalArgument.isNotEmpty((String)filePath, (String)"filePath\u4e0d\u80fd\u4e3a\u7a7a!");
        AssertIllegalArgument.isNotNull((Object)decompressFile, (String)"decompressFile\u4e0d\u80fd\u4e3a\u7a7a!");
        this.assertIsNotDir(decompressFile);
        try {
            this.writeFile(this.getResourceAsStream(filePath), decompressFile);
        }
        catch (IOException e) {
            throw new CompressException(e);
        }
        return this;
    }

    public ZipFile decompress(String filePath, String decompressDir, String fileName) {
        AssertIllegalArgument.isNotNull((Object)decompressDir, (String)"decompressDir\u4e0d\u80fd\u4e3a\u7a7a!");
        AssertIllegalArgument.isNotNull((Object)fileName, (String)"fileName\u4e0d\u80fd\u4e3a\u7a7a!");
        this.decompress(filePath, new File(decompressDir + "/" + fileName));
        return this;
    }

    public static ZipFile compress(File file, File target) {
        return ZipFile.compress(file, target, DEFAULT_ENCODING);
    }

    public static ZipFile compress(File file, File target, String encoding) {
        if (!target.exists()) {
            throw new CompressException("\u6587\u4ef6\u4e0d\u5b58\u5728\uff1a" + target.getAbsolutePath());
        }
        try {
            ZipOutputStream zipOut = new ZipOutputStream(file);
            LOGGER.debug("\u538b\u7f29\u4f7f\u7528\u7f16\u7801\uff1a{}", (Object)encoding);
            zipOut.setEncoding(encoding);
            ZipFile.compress(target.getParentFile(), target, zipOut);
            zipOut.close();
            return new ZipFile(file);
        }
        catch (IOException e) {
            throw new CompressException(e);
        }
    }

    public static ZipFile compressFile(File file, File ... files) {
        return ZipFile.compressFile(file, DEFAULT_ENCODING, files);
    }

    public static ZipFile compressFile(File file, String encoding, File ... files) {
        for (File f : files) {
            if (f.exists()) continue;
            throw new CompressException("\u6587\u4ef6\u4e0d\u5b58\u5728\uff1a" + f.getAbsolutePath());
        }
        try {
            ZipOutputStream zipOut = new ZipOutputStream(file);
            LOGGER.debug("\u538b\u7f29\u4f7f\u7528\u7f16\u7801\uff1a{}", (Object)encoding);
            zipOut.setEncoding(encoding);
            ZipFile.compressFile(zipOut, files);
            zipOut.close();
            return new ZipFile(file);
        }
        catch (IOException e) {
            throw new CompressException(e);
        }
    }

    public InputStream getResourceAsStream(String filePath) {
        try {
            ZipEntry zipEntry = this.getEntry(filePath);
            if (zipEntry == null) {
                return null;
            }
            return this.zipFile.getInputStream(zipEntry);
        }
        catch (IOException e) {
            throw new CompressException(e);
        }
    }

    public void close() {
        try {
            this.zipFile.close();
        }
        catch (IOException e) {
            throw new CompressException(e);
        }
    }

    private static void compress(File baseDir, File file, ZipOutputStream zipOut) throws IOException {
        String basePath = baseDir.getAbsolutePath();
        String relativePath = StringUtils.substringAfter((String)file.getAbsolutePath(), (String)basePath);
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (files.length == 0) {
                zipOut.putNextEntry(new ZipEntry(relativePath + "/"));
                zipOut.closeEntry();
            } else {
                for (File subFile : files) {
                    ZipFile.compress(baseDir, subFile, zipOut);
                }
            }
        } else {
            FileInputStream fis = new FileInputStream(file);
            byte[] buffer = new byte[1024];
            int readedBytes = -1;
            zipOut.putNextEntry(new ZipEntry(relativePath));
            while ((readedBytes = fis.read(buffer)) > 0) {
                zipOut.write(buffer, 0, readedBytes);
            }
            fis.close();
            zipOut.closeEntry();
        }
    }

    private static void compressFile(ZipOutputStream zipOut, File ... files) throws IOException {
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (file.isFile()) {
                FileInputStream fis = new FileInputStream(file);
                byte[] buffer = new byte[1024];
                int readedBytes = -1;
                zipOut.putNextEntry(new ZipEntry(file.getName()));
                while ((readedBytes = fis.read(buffer)) > 0) {
                    zipOut.write(buffer, 0, readedBytes);
                }
                fis.close();
                zipOut.closeEntry();
                continue;
            }
            LOGGER.warn("{}\u4e0d\u662f\u6587\u4ef6", (Object)file.getAbsolutePath());
        }
    }

    private ZipEntry getEntry(String filePath) {
        ZipEntry entry = this.zipFile.getEntry(filePath);
        if (entry == null) {
            LOGGER.debug("\u5728{}ZIP\u6587\u4ef6\u5185\u6ca1\u6709\u627e\u5230{}\uff0c\u8fd4\u56denull", (Object)this.file.getAbsolutePath(), (Object)filePath);
        } else {
            LOGGER.debug("\u5728{}ZIP\u6587\u4ef6\u5185\u627e\u5230{}", (Object)this.file.getAbsolutePath(), (Object)filePath);
        }
        return entry;
    }

    private void assertIsNotFile(File dir) {
        if (dir.exists() && dir.isFile()) {
            throw new CompressException("\u53c2\u6570 {} \u4e0d\u80fd\u662f\u5df2\u5b58\u5728\u7684\u6587\u4ef6\uff01");
        }
    }

    private void assertIsNotDir(File file) {
        if (file.exists() && file.isDirectory()) {
            throw new CompressException("\u53c2\u6570 {} \u4e0d\u80fd\u662f\u5df2\u5b58\u5728\u7684\u76ee\u5f55\uff01");
        }
    }

    private void writeFile(InputStream input, File file) throws IOException {
        File parent = file.getParentFile();
        if (parent != null && !parent.exists()) {
            parent.mkdirs();
            LOGGER.debug("\u89e3\u538b - \u521b\u5efa\u6587\u4ef6\u5939: " + parent.getAbsolutePath());
        }
        LOGGER.debug("\u89e3\u538b - \u521b\u5efa\u6587\u4ef6: " + file.getAbsolutePath());
        try (BufferedInputStream bis = new BufferedInputStream(input);
             FileOutputStream fos = new FileOutputStream(file);
             BufferedOutputStream bos = new BufferedOutputStream(fos, this.bufferSize);){
            int count;
            byte[] data = new byte[this.bufferSize];
            while ((count = bis.read(data, 0, this.bufferSize)) != -1) {
                bos.write(data, 0, count);
            }
            bos.flush();
        }
    }

    private String getEntryFileName(ZipEntry zipEntry) {
        return StringUtils.substringAfterLast((String)this.getEntryPath(zipEntry), (String)"/");
    }

    private String getEntryPath(ZipEntry zipEntry) {
        return UriUtils.convertSeparator((String)zipEntry.getName());
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        int minSize = 512;
        if (bufferSize < 512) {
            bufferSize = 512;
        }
        this.bufferSize = bufferSize;
    }

    public File getFile() {
        return this.file;
    }

    public String getEncoding() {
        return this.zipFile.getEncoding();
    }

    public Enumeration<ZipEntry> getEntries() {
        return this.zipFile.getEntries();
    }
}

