/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.compress.zip;

import cn.featherfly.common.compress.CompressException;
import cn.featherfly.common.compress.CompressProvider;
import cn.featherfly.common.compress.zip.ZipFile;
import cn.featherfly.common.io.FileUtils;
import java.io.File;

public class ZipCompressProvider
implements CompressProvider {
    private static final String EXT_NAME = "zip";

    @Override
    public boolean matchExtName(File compressFile) {
        return EXT_NAME.equalsIgnoreCase(FileUtils.getFileExtName((File)compressFile));
    }

    @Override
    public boolean matchContent(File compressFile) {
        try {
            new ZipFile(compressFile);
            return true;
        }
        catch (CompressException e) {
            return false;
        }
    }

    @Override
    public void decompress(File compressFile, File decompressDir) {
        new ZipFile(compressFile).decompress(decompressDir);
    }
}

