/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.compress;

import cn.featherfly.common.compress.CompressException;
import cn.featherfly.common.compress.CompressProvider;
import cn.featherfly.common.compress.zip.ZipCompressProvider;
import cn.featherfly.common.lang.ServiceLoaderUtils;
import cn.featherfly.common.lang.StringUtils;
import java.io.File;
import java.util.HashSet;
import java.util.Set;

public final class CompressUtils {
    private static final Set<CompressProvider> COMPRESS_PROVIDERS = new HashSet<CompressProvider>();

    private CompressUtils() {
    }

    public static void decompress(File compressFile, File decompressDir) {
        for (CompressProvider provider : COMPRESS_PROVIDERS) {
            if (!provider.matchExtName(compressFile)) continue;
            provider.decompress(compressFile, decompressDir);
            return;
        }
        for (CompressProvider provider : COMPRESS_PROVIDERS) {
            if (!provider.matchContent(compressFile)) continue;
            provider.decompress(compressFile, decompressDir);
            return;
        }
        throw new CompressException(StringUtils.format((String)"there is no CompressProvider can work with this file #1 in #2", (String[])new String[]{compressFile.getAbsolutePath(), COMPRESS_PROVIDERS.toString()}));
    }

    static {
        COMPRESS_PROVIDERS.add(new ZipCompressProvider());
        COMPRESS_PROVIDERS.addAll(ServiceLoaderUtils.loadAll(CompressProvider.class));
    }
}

