/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.gentool.exception.util;

import cn.featherfly.common.lang.ArrayUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExceptionCodeCheck {
    private static final ExceptionCodeCheck CHECK = new ExceptionCodeCheck();
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    Map<String, Class<?>> codes = new HashMap(0);

    private ExceptionCodeCheck() {
    }

    private void checkCodeDuplicate(Class<?> exceptionCodeType) {
        Class<?> codeEnumType = exceptionCodeType.getClasses()[0];
        for (Object e : codeEnumType.getEnumConstants()) {
            String code = e.toString();
            this.logger.debug("check code {} declared in type {}", (Object)code, (Object)exceptionCodeType.getName());
            Class<?> t = this.codes.put(e.toString(), exceptionCodeType);
            if (t == null || t == exceptionCodeType) continue;
            throw new RuntimeException("duplicate code " + code + " declared in type " + exceptionCodeType.getName() + " " + t.getName());
        }
    }

    public static void checkCode(Class<?> exceptionCodeType) {
        CHECK.checkCodeDuplicate(exceptionCodeType);
    }

    public static void checkCode(Collection<Class<?>> exceptionCodeTypes) {
        exceptionCodeTypes.forEach(e -> ExceptionCodeCheck.checkCode(e));
    }

    public static void checkCode(Class<?>[] exceptionCodeTypes) {
        ExceptionCodeCheck.checkCode(ArrayUtils.toList((Object[])exceptionCodeTypes));
    }
}

