/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.gentool.exception;

import cn.featherfly.common.gentool.exception.GenerateConfig;
import cn.featherfly.common.gentool.exception.module.GenModule;
import cn.featherfly.common.lang.ClassLoaderUtils;
import cn.featherfly.common.lang.ClassUtils;
import cn.featherfly.common.lang.UriUtils;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.templateresolver.ClassLoaderTemplateResolver;
import org.thymeleaf.templateresolver.ITemplateResolver;

public class Generator {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    TemplateEngine templateEngine;
    GenerateConfig config;

    protected Generator(GenerateConfig config) {
        this.config = config;
        ClassLoaderTemplateResolver templateResolver = new ClassLoaderTemplateResolver();
        templateResolver.setTemplateMode(TemplateMode.TEXT);
        templateResolver.setPrefix(config.getTemplateDir());
        templateResolver.setSuffix(config.getTemplateSuffix());
        this.templateEngine = new TemplateEngine();
        this.templateEngine.setTemplateResolver((ITemplateResolver)templateResolver);
    }

    public void generate(String filePath) throws Exception {
        this.generate(this.read(filePath));
    }

    public void generate(GenModule genModule) throws IOException {
        Context context = new Context();
        context.setVariable("packageName", (Object)genModule.getPackageName());
        context.setVariable("author", (Object)genModule.getAuthor());
        context.setVariable("code", (Object)genModule.getCode());
        context.setVariable("exception", (Object)genModule.getException());
        String javaRootPath = this.config.getJavaSrcDir();
        String resourceRootPath = this.config.getResourceDir();
        String exceptionJavaFile = UriUtils.linkUri((String[])new String[]{javaRootPath, ClassUtils.packageToDir((String)genModule.getException().getPackageName()), genModule.getException().getName() + ".java"});
        this.logger.debug("generated exceptionJavaFile -> {}", (Object)exceptionJavaFile);
        String codeJavaFile = UriUtils.linkUri((String[])new String[]{javaRootPath, ClassUtils.packageToDir((String)genModule.getCode().getPackageName()), genModule.getCode().getName() + ".java"});
        this.logger.debug("generated exceptionCodeJavaFile -> {}", (Object)codeJavaFile);
        FileUtils.write((File)new File(exceptionJavaFile), (CharSequence)this.templateEngine.process("exception", (IContext)context), (String)"UTF-8");
        FileUtils.write((File)new File(codeJavaFile), (CharSequence)this.templateEngine.process("code", (IContext)context), (String)"UTF-8");
        String propertiesFile = UriUtils.linkUri((String[])new String[]{resourceRootPath, ClassUtils.packageToDir((String)genModule.getException().getPackageName()), genModule.getException().getName()});
        genModule.getCode().getLocales().forEach((locale, properties) -> {
            try {
                File file = new File(propertiesFile + "_" + locale + ".properties");
                if (!file.exists()) {
                    FileUtils.writeByteArrayToFile((File)file, (byte[])new byte[0]);
                }
                FileOutputStream out = new FileOutputStream(file);
                this.logger.debug("generated properties file -> {}", (Object)file.getAbsolutePath());
                properties.store(out, genModule.getCode().getModule() + " " + locale);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    private GenModule read(String filePath) throws JsonProcessingException, IOException {
        this.logger.debug("read genfile file -> {}", (Object)filePath);
        YAMLFactory yamlFactory = new YAMLFactory();
        ObjectMapper mapper = new ObjectMapper((JsonFactory)yamlFactory);
        mapper.enable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        InputStream input = ClassLoaderUtils.getResourceAsStream((String)filePath, this.getClass());
        return (GenModule)mapper.readerFor(GenModule.class).readValue(input);
    }
}

