/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.gentool.exception.module;

import cn.featherfly.common.exception.SimpleLocalizedExceptionCode;
import cn.featherfly.common.gentool.exception.module.ClassModule;
import cn.featherfly.common.gentool.exception.module.ExceptionCodeInstanceModule;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

public class ExceptionCodeModule
extends ClassModule {
    public static final Class<SimpleLocalizedExceptionCode> DEFAULT_PARENT = SimpleLocalizedExceptionCode.class;
    private String module;
    private List<ExceptionCodeInstanceModule> codes = new ArrayList<ExceptionCodeInstanceModule>(0);
    private Map<Locale, Properties> locales = new HashMap<Locale, Properties>();

    @Override
    public Class<?> getParent() {
        return super.getParent() != null ? super.getParent() : DEFAULT_PARENT;
    }

    public List<ExceptionCodeInstanceModule> getCodes() {
        return this.codes;
    }

    public void setCodes(List<ExceptionCodeInstanceModule> codes) {
        this.codes = codes;
    }

    public String getModule() {
        return this.module;
    }

    public void setModule(String module) {
        this.module = module;
    }

    @JsonIgnore
    public Map<Locale, Properties> getLocales() {
        if (this.locales.isEmpty()) {
            this.generateLocales();
        }
        return this.locales;
    }

    public void generateLocales() {
        this.locales.clear();
        this.codes.forEach(code -> code.getMessages().forEach((key, value) -> {
            Properties p = this.locales.get(key);
            if (p == null) {
                p = new Properties();
                this.locales.put((Locale)key, p);
            }
            p.setProperty(code.getKey(), (String)value);
        }));
    }
}

