/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.gentool.exception;

import cn.featherfly.common.lang.ClassLoaderUtils;
import cn.featherfly.common.lang.LangUtils;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenerateConfig {
    protected static final Logger logger = LoggerFactory.getLogger(GenerateConfig.class);
    private String javaSrcDir;
    private String resourceDir;
    private String templateDir = "cn/featherfly/common/gentool/exception/template/";
    private String templateSuffix = ".template";

    public String getJavaSrcDir() {
        return this.javaSrcDir;
    }

    public void setJavaSrcDir(String javaSrcDir) {
        this.javaSrcDir = javaSrcDir;
    }

    public String getResourceDir() {
        return this.resourceDir;
    }

    public void setResourceDir(String resourceDir) {
        this.resourceDir = resourceDir;
    }

    public String getTemplateDir() {
        return this.templateDir;
    }

    public void setTemplateDir(String templateDir) {
        this.templateDir = templateDir;
    }

    public String getTemplateSuffix() {
        return this.templateSuffix;
    }

    public void setTemplateSuffix(String templateSuffix) {
        this.templateSuffix = templateSuffix;
    }

    public static GenerateConfig create(String filePath) throws Exception {
        if (LangUtils.isEmpty((String)filePath)) {
            filePath = "gentool/config.yaml";
        }
        logger.debug("read config file -> {}", (Object)filePath);
        YAMLFactory yamlFactory = new YAMLFactory();
        ObjectMapper mapper = new ObjectMapper((JsonFactory)yamlFactory);
        mapper.enable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        InputStream input = ClassLoaderUtils.getResourceAsStream((String)filePath, GenerateConfig.class);
        return (GenerateConfig)mapper.readerFor(GenerateConfig.class).readValue(input);
    }
}

