/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.bean;

import cn.featherfly.common.bean.BeanProperty;
import cn.featherfly.common.bean.BeanPropertyFactory;
import cn.featherfly.common.bean.NoSuchPropertyException;
import cn.featherfly.common.bean.PropertyAccessException;
import cn.featherfly.common.lang.WordUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavassistBeanPropertyFactory
implements BeanPropertyFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(JavassistBeanPropertyFactory.class);

    public <T> BeanProperty<T> create(String propertyName, Field field, Class<T> propertyType, Method setMethod, Method getMethod, Class<?> ownerType, Class<?> declaringType) {
        try {
            return this.create(ownerType, propertyName, field, propertyType, setMethod, getMethod, declaringType);
        }
        catch (Exception e) {
            throw new NoSuchPropertyException(ownerType, field.getName(), (Throwable)e);
        }
    }

    private <T> BeanProperty<T> create(Class<?> ownerType, String name, Field field, Class<T> propertyType, Method setMethod, Method getMethod, Class<?> declaringType) {
        if (setMethod == null && getMethod == null) {
            throw new NoSuchPropertyException(ownerType, name);
        }
        try {
            ClassPool pool = ClassPool.getDefault();
            String upperCaseFirstName = WordUtils.upperCaseFirst((String)name);
            String propertyClassName = ownerType.getPackage() + "._" + ownerType.getSimpleName() + upperCaseFirstName + "Property";
            CtClass beanPropertyClass = pool.makeClass(propertyClassName);
            beanPropertyClass.setSuperclass(pool.getCtClass(BeanProperty.class.getName()));
            CtConstructor constraConstructor = new CtConstructor(new CtClass[]{pool.getCtClass(String.class.getName()), pool.getCtClass(Field.class.getName()), pool.getCtClass(Class.class.getName()), pool.getCtClass(Method.class.getName()), pool.getCtClass(Method.class.getName()), pool.getCtClass(Class.class.getName()), pool.getCtClass(Class.class.getName())}, beanPropertyClass);
            constraConstructor.setModifiers(1);
            constraConstructor.setBody("super($1, $2, $3, $4, $5, $6, $7);");
            beanPropertyClass.addConstructor(constraConstructor);
            CtClass objectType = pool.get(Object.class.getName());
            String setterName = "set" + upperCaseFirstName;
            CtMethod setter = new CtMethod(CtClass.voidType, "setValue", new CtClass[]{objectType, objectType}, beanPropertyClass);
            String setterBody = null;
            setterBody = setMethod == null ? String.format("{throw new " + PropertyAccessException.class.getName() + "(%s.class,\"%s\",\"\u5c5e\u6027\u4e0d\u53ef\u5199\");" + "}", ownerType.getName(), name) : String.format("{%1$s value = (%1$s) $2;%2$s obj = (%2$s)$1;obj.%3$s(value);}", propertyType.getName(), ownerType.getName(), setterName);
            LOGGER.trace("\u7c7b\u578b{}\u5c5e\u6027{}\u7684\u8bbe\u7f6e\u65b9\u6cd5\u5185\u5bb9\uff1a{}", new Object[]{ownerType.getName(), name, setterBody});
            setter.setBody(setterBody);
            setter.setModifiers(1);
            beanPropertyClass.addMethod(setter);
            String getterName = "get" + upperCaseFirstName;
            CtMethod getter = new CtMethod(objectType, "getValue", new CtClass[]{objectType}, beanPropertyClass);
            String getterBody = null;
            getterBody = getMethod == null ? String.format("{throw new " + PropertyAccessException.class.getName() + "(%s.class,\"%s\",\"\u5c5e\u6027\u4e0d\u53ef\u8bfb\");" + "}", ownerType.getName(), name) : String.format("{%1$s obj = (%1$s)$1;return obj.%2$s();}", ownerType.getName(), getterName);
            LOGGER.trace("\u7c7b\u578b{}\u5c5e\u6027{}\u7684\u8bfb\u53d6\u65b9\u6cd5\u5185\u5bb9\uff1a{}", new Object[]{ownerType.getName(), name, getterBody});
            getter.setBody(getterBody);
            getter.setModifiers(1);
            beanPropertyClass.addMethod(getter);
            beanPropertyClass.toClass();
            beanPropertyClass.detach();
            return (BeanProperty)Class.forName(propertyClassName).getConstructor(String.class, Field.class, Class.class, Method.class, Method.class, Class.class, Class.class).newInstance(name, field, propertyType, setMethod, getMethod, ownerType, declaringType);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

