/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.bean;

import cn.featherfly.common.bean.BeanProperty;
import cn.featherfly.common.bean.BeanPropertyFactory;
import cn.featherfly.common.bean.NoSuchPropertyException;
import cn.featherfly.common.bean.PropertyAccessException;
import cn.featherfly.common.lang.ClassUtils;
import cn.featherfly.common.lang.WordUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavassistBeanPropertyFactory
implements BeanPropertyFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(JavassistBeanPropertyFactory.class);

    public <T> BeanProperty<T> create(Class<T> type, Field field, Method setMethod, Method getMethod) {
        try {
            return this.create(type, field.getName(), field, setMethod, getMethod);
        }
        catch (Exception e) {
            throw new NoSuchPropertyException(type, field.getName(), (Throwable)e);
        }
    }

    public <T> BeanProperty<T> create(Class<T> type, String propertyName) {
        try {
            Field field = type.getDeclaredField(propertyName);
            Method getter = ClassUtils.getGetter((Field)field, type);
            Method setter = ClassUtils.getSetter((Field)field, type);
            return this.create(type, propertyName, field, setter, getter);
        }
        catch (Exception e) {
            throw new NoSuchPropertyException(type, propertyName, (Throwable)e);
        }
    }

    private <T> BeanProperty<T> create(Class<T> type, String name, Field field, Method setMethod, Method getMethod) {
        if (setMethod == null && getMethod == null) {
            throw new NoSuchPropertyException(type, name, "\u6ca1\u6709\u8bfb\u53d6\u548c\u5199\u5165\u65b9\u6cd5");
        }
        try {
            ClassPool pool = ClassPool.getDefault();
            String upperCaseFirstName = WordUtils.upperCaseFirst((String)name);
            String propertyClassName = type.getPackage() + "._" + type.getSimpleName() + upperCaseFirstName + "Property";
            CtClass beanPropertyClass = pool.makeClass(propertyClassName);
            beanPropertyClass.setSuperclass(pool.getCtClass(BeanProperty.class.getName()));
            CtConstructor constraConstructor = new CtConstructor(new CtClass[]{pool.getCtClass(Field.class.getName()), pool.getCtClass(Method.class.getName()), pool.getCtClass(Method.class.getName())}, beanPropertyClass);
            constraConstructor.setModifiers(1);
            constraConstructor.setBody("super(" + type.getName() + ".class, $1, $2, $3);");
            beanPropertyClass.addConstructor(constraConstructor);
            CtClass objectType = pool.get(Object.class.getName());
            String setterName = "set" + upperCaseFirstName;
            CtMethod setter = new CtMethod(CtClass.voidType, "setValue", new CtClass[]{objectType, objectType}, beanPropertyClass);
            String setterBody = null;
            setterBody = setMethod == null ? String.format("{throw new " + PropertyAccessException.class.getName() + "(%s.class,\"%s\",\"\u5c5e\u6027\u4e0d\u53ef\u5199\");" + "}", type.getName(), name) : String.format("{%1$s value = (%1$s) $2;%2$s obj = (%2$s)$1;obj.%3$s(value);}", field.getType().getName(), type.getName(), setterName);
            LOGGER.trace("\u7c7b\u578b{}\u5c5e\u6027{}\u7684\u8bbe\u7f6e\u65b9\u6cd5\u5185\u5bb9\uff1a{}", new Object[]{type.getName(), name, setterBody});
            setter.setBody(setterBody);
            setter.setModifiers(1);
            beanPropertyClass.addMethod(setter);
            String getterName = "get" + upperCaseFirstName;
            CtMethod getter = new CtMethod(objectType, "getValue", new CtClass[]{objectType}, beanPropertyClass);
            String getterBody = null;
            getterBody = getMethod == null ? String.format("{throw new " + PropertyAccessException.class.getName() + "(%s.class,\"%s\",\"\u5c5e\u6027\u4e0d\u53ef\u8bfb\");" + "}", type.getName(), name) : String.format("{%1$s obj = (%1$s)$1;return obj.%2$s();}", type.getName(), getterName);
            LOGGER.trace("\u7c7b\u578b{}\u5c5e\u6027{}\u7684\u8bfb\u53d6\u65b9\u6cd5\u5185\u5bb9\uff1a{}", new Object[]{type.getName(), name, getterBody});
            getter.setBody(getterBody);
            getter.setModifiers(1);
            beanPropertyClass.addMethod(getter);
            beanPropertyClass.toClass();
            beanPropertyClass.detach();
            return (BeanProperty)Class.forName(propertyClassName).getConstructor(Field.class, Method.class, Method.class).newInstance(field, setMethod, getMethod);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

