/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.easyapi.codegen;

import cn.featherfly.common.lang.ClassLoaderUtils;
import cn.featherfly.common.lang.Strings;
import cn.featherfly.easyapi.codegen.GenConstants;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.IOException;
import java.io.Writer;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class MergeDocs {
    public static final String SCHEMAS = "schemas";
    public static final String REF_NODE_NAME = "$ref";
    private static final ObjectMapper MAPPER = new ObjectMapper((JsonFactory)new YAMLFactory());

    private static Map<String, JsonNode> findSchemasNodes(String file, Set<String> includeSchemas, String relativePathRoot) throws IOException {
        URL fileUrl = ClassLoaderUtils.getResource((String)file);
        String path = Strings.substringAfterLast((String)fileUrl.getPath(), (String)relativePathRoot);
        path = Strings.substringBeforeLast((String)("./" + path), (String)"/");
        JsonNode rootNode = MAPPER.readTree(fileUrl);
        HashMap<String, JsonNode> schemaNodes = new HashMap<String, JsonNode>();
        includeSchemas.forEach(s -> {
            String name = Strings.substringAfterLast((String)s, (String)"/");
            JsonNode n = rootNode.findValue(SCHEMAS).findValue(name);
            if (n == null) {
                throw new RuntimeException("read schema " + name + "  from " + file + " error, schema not exits");
            }
            schemaNodes.put(name, n);
        });
        for (JsonNode node : schemaNodes.values()) {
            Map<String, Set<String>> extFilesComponents = MergeDocs.findExtFilesComponents(node, path, true, file);
            Set<String> defines = extFilesComponents.get(file);
            if (defines != null) {
                Iterator<String> iter = defines.iterator();
                while (iter.hasNext()) {
                    if (!includeSchemas.contains(iter.next())) continue;
                    iter.remove();
                }
            }
            for (Map.Entry<String, Set<String>> entry : extFilesComponents.entrySet()) {
                Map<String, JsonNode> newSchemasNodes = MergeDocs.findSchemasNodes(entry.getKey(), entry.getValue(), relativePathRoot);
                schemaNodes.putAll(newSchemasNodes);
            }
        }
        return schemaNodes;
    }

    public static void mergeSchemas(String target, Writer writer) throws IOException {
        JsonNode jsonNode = MergeDocs.mergeSchemas(target);
        MAPPER.writer().writeValue(writer, (Object)jsonNode);
        writer.close();
    }

    private static void extFiles(JsonNode jsonNode, Map<String, Set<String>> extFilesComponents, String path) {
        jsonNode.findValues(REF_NODE_NAME).forEach(ref -> {
            String rv = ref.asText();
            if (rv.startsWith("./") || rv.startsWith("../")) {
                String extFile = StringUtils.substringBefore((String)rv, (String)"#");
                extFile = path + "/" + extFile;
                HashSet<String> components = (HashSet<String>)extFilesComponents.get(extFile);
                if (components == null) {
                    components = new HashSet<String>();
                    extFilesComponents.put(extFile, components);
                }
                components.add(StringUtils.substringAfter((String)rv, (String)"#"));
            }
        });
    }

    private static Map<String, Set<String>> findExtFilesComponents(JsonNode node, String relativePathRoot, boolean includeCuurent, String cuurentFile) {
        HashMap<String, Set<String>> extFilesComponents = new HashMap<String, Set<String>>();
        node.findParents(REF_NODE_NAME).forEach(refNode -> {
            String rv = refNode.findPath(REF_NODE_NAME).asText();
            if (rv.startsWith("./") || rv.startsWith("../")) {
                HashSet<String> components;
                String extFile = StringUtils.substringBefore((String)rv, (String)"#");
                if (relativePathRoot.length() > 0) {
                    extFile = relativePathRoot + "/" + extFile;
                }
                if ((components = (HashSet<String>)extFilesComponents.get(extFile)) == null) {
                    components = new HashSet<String>();
                    extFilesComponents.put(extFile, components);
                }
                String include = StringUtils.substringAfter((String)rv, (String)"#");
                components.add(include);
                ((ObjectNode)refNode).set(REF_NODE_NAME, (JsonNode)new TextNode("#" + include));
            } else if (includeCuurent) {
                String extFile = cuurentFile;
                HashSet<String> components = (HashSet<String>)extFilesComponents.get(extFile);
                if (components == null) {
                    components = new HashSet<String>();
                    extFilesComponents.put(extFile, components);
                }
                String include = StringUtils.substringAfter((String)rv, (String)"#");
                components.add(include);
            }
        });
        return extFilesComponents;
    }

    public static JsonNode mergeSchemas(String target) throws IOException {
        URL targetURL = ClassLoaderUtils.getResource((String)target, MergeDocs.class);
        String relativePath = Strings.substringBeforeLast((String)target, (String)"/");
        String rootPath = StringUtils.substringBeforeLast((String)targetURL.getPath(), (String)target);
        GenConstants.LOG.info("target: {}", (Object)targetURL);
        JsonNode rootNode = MAPPER.readTree(targetURL);
        Map<String, Set<String>> extFilesComponents = MergeDocs.findExtFilesComponents(rootNode, relativePath, false, target);
        ObjectNode schemaNode = (ObjectNode)rootNode.findValue(SCHEMAS);
        if (schemaNode == null) {
            System.out.println("there is no schemas found in " + targetURL.getPath());
            return rootNode;
        }
        for (Map.Entry<String, Set<String>> entry : extFilesComponents.entrySet()) {
            Map<String, JsonNode> newSchemasNodes = MergeDocs.findSchemasNodes(entry.getKey(), entry.getValue(), rootPath);
            newSchemasNodes.forEach((k, v) -> schemaNode.set(k, v));
        }
        return rootNode;
    }
}

