/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.easyapi.codegen;

import cn.featherfly.common.io.FileUtils;
import cn.featherfly.common.lang.ClassLoaderUtils;
import cn.featherfly.easyapi.codegen.EasyapiAbstractJavaCodegen;
import cn.featherfly.easyapi.codegen.EasyapiDefaultGenerator;
import cn.featherfly.easyapi.codegen.EnableExtParameters;
import cn.featherfly.easyapi.codegen.ExtParameter;
import cn.featherfly.easyapi.codegen.MergeDocs;
import cn.featherfly.easyapi.codegen.ModuleAbility;
import cn.featherfly.easyapi.codegen.WrapResponseAbility;
import io.swagger.codegen.v3.CliOption;
import io.swagger.codegen.v3.ClientOptInput;
import io.swagger.codegen.v3.ClientOpts;
import io.swagger.codegen.v3.CodegenConfig;
import io.swagger.codegen.v3.config.Config;
import io.swagger.codegen.v3.config.ConfigParser;
import io.swagger.codegen.v3.generators.DefaultCodegenConfig;
import io.swagger.parser.OpenAPIParser;
import io.swagger.v3.parser.core.models.SwaggerParseResult;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenerateCode
implements EnableExtParameters,
WrapResponseAbility,
ModuleAbility {
    public static final Logger LOG = LoggerFactory.getLogger(GenerateCode.class);
    private boolean wrapResponse;
    private String module;
    private String secondModule;
    private boolean verbose;
    private String output = "";
    private String spec = "";
    private boolean generateTests;
    private boolean generateModelDocs;
    private boolean generateApiDocs;
    private boolean generateSwaggerMetadata;
    private boolean generateModels = true;
    private boolean generateApis = true;
    private boolean generateSupportingFiles;
    private String templateDir = null;
    private String systemProperties;
    private String configFile = "";
    private String apiPath;
    public String sourceFolder = "java";
    private boolean mergeDoc = true;
    protected Collection<ExtParameter> extParameters = new HashSet<ExtParameter>();

    private static CodegenConfig forName(String name) {
        ServiceLoader<CodegenConfig> loader = ServiceLoader.load(CodegenConfig.class);
        for (CodegenConfig config : loader) {
            if (!config.getName().equals(name)) continue;
            return config;
        }
        try {
            return (CodegenConfig)Class.forName(name).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Can't load config class with name ".concat(name), e);
        }
    }

    public void run(DefaultCodegenConfig codegen) {
        if (codegen instanceof WrapResponseAbility) {
            WrapResponseAbility wrapResponseAbility = (WrapResponseAbility)codegen;
            wrapResponseAbility.setWrapResponse(this.wrapResponse);
        }
        if (codegen instanceof ModuleAbility) {
            ModuleAbility moduleAbility = (ModuleAbility)codegen;
            moduleAbility.setModule(this.module);
            moduleAbility.setSecondModule(this.secondModule);
        }
        if (this.mergeDoc) {
            String fileName = this.getSpec();
            String newFileName = fileName.replaceAll(".yaml", ".merged.yaml");
            String newFilePath = ClassLoaderUtils.getResource((String)".").getPath() + newFileName;
            File newFile = new File(newFilePath);
            FileUtils.makeDirectory((File)newFile);
            try {
                MergeDocs.mergeSchemas(fileName, new OutputStreamWriter((OutputStream)new FileOutputStream(new File(newFilePath)), StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.setSpec(newFileName);
        }
        this.verbosed(this.verbose);
        this.setSystemProperties();
        ClientOptInput input = new ClientOptInput();
        codegen.setOutputDir(new File(this.output).getAbsolutePath());
        if (codegen instanceof EnableExtParameters) {
            ((EnableExtParameters)codegen).getExtParameters().addAll(this.extParameters);
        }
        if (codegen instanceof EasyapiAbstractJavaCodegen) {
            ((EasyapiAbstractJavaCodegen)codegen).setSourceFolder(this.sourceFolder);
        }
        System.setProperty("generateApis", this.generateApis + "");
        System.setProperty("apiDocs", this.generateApiDocs + "");
        System.setProperty("apiTests", this.generateTests + "");
        System.setProperty("generateModels", this.generateModels + "");
        System.setProperty("modelDocs", this.generateModelDocs + "");
        System.setProperty("modelTests", this.generateTests + "");
        System.setProperty("supportingFiles", this.generateSupportingFiles + "");
        if (null != this.templateDir) {
            System.out.println("templateDir: " + this.templateDir);
            codegen.additionalProperties().put("templateDir", this.templateDir);
            if (this.apiPath != null && !"".equals(this.apiPath)) {
                codegen.additionalProperties().put("apiPath", this.apiPath);
            }
        }
        if (null != this.configFile) {
            URL configFileUrl = ClassLoaderUtils.getResource((String)this.configFile, this.getClass());
            System.out.println("configFile: " + configFileUrl);
            if (configFileUrl == null) {
                throw new IllegalArgumentException("configFile is not found with " + this.configFile);
            }
            Config genConfig = ConfigParser.read((String)configFileUrl.getPath());
            if (null != genConfig) {
                for (CliOption langCliOption : codegen.cliOptions()) {
                    if (!genConfig.hasOption(langCliOption.getOpt())) continue;
                    if ("modelPackage".equals(langCliOption.getOpt())) {
                        codegen.setModelPackage(genConfig.getOption(langCliOption.getOpt()));
                        codegen.additionalProperties().put(langCliOption.getOpt(), codegen.modelPackage());
                        continue;
                    }
                    if ("apiPackage".equals(langCliOption.getOpt())) {
                        codegen.setApiPackage(genConfig.getOption(langCliOption.getOpt()));
                        codegen.additionalProperties().put(langCliOption.getOpt(), codegen.apiPackage());
                        continue;
                    }
                    codegen.additionalProperties().put(langCliOption.getOpt(), genConfig.getOption(langCliOption.getOpt()));
                }
                if (genConfig.hasOption("title") && codegen instanceof EasyapiAbstractJavaCodegen) {
                    ((EasyapiAbstractJavaCodegen)codegen).setTitle(genConfig.getOption("title"));
                }
            }
        }
        URL specUrl = ClassLoaderUtils.getResource((String)this.spec, this.getClass());
        System.out.println("spec: " + specUrl);
        SwaggerParseResult swaggerParseResult = new OpenAPIParser().readLocation(specUrl.toString(), input.getAuthorizationValues(), null);
        EasyapiDefaultGenerator generator = new EasyapiDefaultGenerator();
        generator.setGenerateSwaggerMetadata(this.generateSwaggerMetadata);
        List files = generator.opts(input.opts(new ClientOpts()).config((CodegenConfig)codegen).openAPI(swaggerParseResult.getOpenAPI())).generate();
        for (File file : files) {
            System.out.println("generate file : " + file.getAbsolutePath());
        }
    }

    private void setSystemProperties() {
        if (this.systemProperties != null && this.systemProperties.length() > 0) {
            for (String property : this.systemProperties.split(",")) {
                int ix = property.indexOf(61);
                if (ix <= 0 || ix >= property.length() - 1) continue;
                System.setProperty(property.substring(0, ix), property.substring(ix + 1));
            }
        }
    }

    private void verbosed(boolean verbose) {
        if (!verbose) {
            return;
        }
        LOG.info("\nVERBOSE MODE: ON. Additional debug options are injected\n - [debugSwagger] prints the swagger specification as interpreted by the codegen\n - [debugModels] prints models passed to the template engine\n - [debugOperations] prints operations passed to the template engine\n - [debugSupportingFiles] prints additional data passed to the template engine");
        System.setProperty("debugSwagger", "");
        System.setProperty("debugModels", "");
        System.setProperty("debugOperations", "");
        System.setProperty("debugSupportingFiles", "");
    }

    public GenerateCode withPathPrefix(String apiPath) {
        this.apiPath = apiPath;
        return this;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }

    public void setOutput(String output) {
        this.output = output;
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }

    public void setApiPath(String apiPath) {
        this.apiPath = apiPath;
    }

    public void setTemplateDir(String templateDir) {
        this.templateDir = templateDir;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public String getOutput() {
        return this.output;
    }

    public String getSpec() {
        return this.spec;
    }

    public boolean isGenerateTests() {
        return this.generateTests;
    }

    public boolean isGenerateModelDocs() {
        return this.generateModelDocs;
    }

    public void setGenerateModelDocs(boolean generateModelDocs) {
        this.generateModelDocs = generateModelDocs;
    }

    public String getTemplateDir() {
        return this.templateDir;
    }

    public String getSystemProperties() {
        return this.systemProperties;
    }

    public void setSystemProperties(String systemProperties) {
        this.systemProperties = systemProperties;
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public String getApiPath() {
        return this.apiPath;
    }

    public String getSourceFolder() {
        return this.sourceFolder;
    }

    public void setSourceFolder(String sourceFolder) {
        this.sourceFolder = sourceFolder;
    }

    public void setGenerateTests(boolean generateTests) {
        this.generateTests = generateTests;
    }

    public boolean isGenerateApiDocs() {
        return this.generateApiDocs;
    }

    public void setGenerateApiDocs(boolean generateApiDocs) {
        this.generateApiDocs = generateApiDocs;
    }

    public boolean isGenerateSwaggerMetadata() {
        return this.generateSwaggerMetadata;
    }

    public void setGenerateSwaggerMetadata(boolean generateSwaggerMetadata) {
        this.generateSwaggerMetadata = generateSwaggerMetadata;
    }

    public boolean isGenerateModels() {
        return this.generateModels;
    }

    public void setGenerateModels(boolean generateModels) {
        this.generateModels = generateModels;
    }

    public boolean isGenerateApis() {
        return this.generateApis;
    }

    public void setGenerateApis(boolean generateApis) {
        this.generateApis = generateApis;
    }

    public boolean isGenerateSupportingFiles() {
        return this.generateSupportingFiles;
    }

    public void setGenerateSupportingFiles(boolean generateSupportingFiles) {
        this.generateSupportingFiles = generateSupportingFiles;
    }

    @Override
    public Collection<ExtParameter> getExtParameters() {
        return this.extParameters;
    }

    @Override
    public EnableExtParameters addExtParameter(ExtParameter extParameter) {
        if (extParameter != null) {
            this.extParameters.add(extParameter);
        }
        return this;
    }

    public boolean isMergeDoc() {
        return this.mergeDoc;
    }

    public void setMergeDoc(boolean mergeDoc) {
        this.mergeDoc = mergeDoc;
    }

    @Override
    public boolean isWrapResponse() {
        return this.wrapResponse;
    }

    @Override
    public void setWrapResponse(boolean wrapResponse) {
        this.wrapResponse = wrapResponse;
    }

    @Override
    public String toModelFilename(String name, String templateName) {
        return name;
    }

    @Override
    public String getModule() {
        return this.module;
    }

    @Override
    public void setModule(String module) {
        this.module = module;
    }

    @Override
    public String getSecondModule() {
        return this.secondModule;
    }

    @Override
    public void setSecondModule(String secondModule) {
        this.secondModule = secondModule;
    }
}

