/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.easyapi.codegen;

import cn.featherfly.common.lang.ClassLoaderUtils;
import cn.featherfly.easyapi.codegen.DefaultGenerator;
import io.swagger.codegen.v3.CodegenConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Scanner;

public class EasyapiDefaultGenerator
extends DefaultGenerator {
    public String getFullTemplateFile(CodegenConfig config, String templateFile) {
        String libTemplateFile;
        String template = config.templateDir() + File.separator + templateFile;
        if (ClassLoaderUtils.getResource((String)this.getCPResourcePath(template), ((Object)((Object)this)).getClass()) != null) {
            return template;
        }
        String library = config.getLibrary();
        if (library != null && !"".equals(library) && this.embeddedTemplateExists(libTemplateFile = config.embeddedTemplateDir() + File.separator + "libraries" + File.separator + library + File.separator + templateFile)) {
            return libTemplateFile;
        }
        return config.embeddedTemplateDir() + File.separator + templateFile;
    }

    public String readTemplate(String name) {
        try {
            Reader reader = this.getTemplateReader(name);
            if (reader == null) {
                throw new RuntimeException("no file found");
            }
            Scanner s = new Scanner(reader).useDelimiter("\\A");
            return s.hasNext() ? s.next() : "";
        }
        catch (Exception e) {
            this.LOGGER.error(e.getMessage());
            throw new RuntimeException("can't load template " + name);
        }
    }

    public Reader getTemplateReader(String name) {
        try {
            InputStream is = ClassLoaderUtils.getResourceAsStream((String)this.getCPResourcePath(name), ((Object)((Object)this)).getClass());
            if (is == null) {
                is = new FileInputStream(new File(name));
            }
            return new InputStreamReader(is, "UTF-8");
        }
        catch (Exception e) {
            this.LOGGER.error(e.getMessage());
            throw new RuntimeException("can't load template " + name);
        }
    }
}

