/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.constant.spring;

import cn.featherfly.constant.ConstantConfigurator;
import cn.featherfly.constant.ConstantPool;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;

public class ConstantConfigurer
implements BeanFactoryPostProcessor {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        this.logger.debug("start regist constant to spring");
        if (!ConstantPool.isInit()) {
            ConstantConfigurator.config();
        }
        ConstantPool pool = ConstantPool.getDefault();
        Collection constants = pool.getConstants();
        for (Object constant : constants) {
            this.logger.debug("regist -> {} ", (Object)constant.getClass().getName());
            beanFactory.registerSingleton(constant.getClass().getName(), constant);
        }
        this.logger.debug("end regist constant to spring");
    }
}

