/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.rc.repository;

import cn.featherfly.common.lang.ClassUtils;
import cn.featherfly.conversion.string.ToStringConversionPolicys;
import cn.featherfly.conversion.string.ToStringTypeConversion;
import cn.featherfly.hammer.Hammer;
import cn.featherfly.hammer.dsl.execute.ExecutableConditionGroupExpression;
import cn.featherfly.hammer.dsl.execute.ExecutableConditionGroupLogicExpression;
import cn.featherfly.hammer.dsl.execute.ExecutableUpdate;
import cn.featherfly.hammer.dsl.query.QueryConditionGroupExpression;
import cn.featherfly.hammer.dsl.query.QueryConditionGroupLogicExpression;
import cn.featherfly.hammer.dsl.query.QueryEntityProperties;
import cn.featherfly.hammer.dsl.query.QuerySortExpression;
import cn.featherfly.rc.Configuration;
import cn.featherfly.rc.ConfigurationException;
import cn.featherfly.rc.ConfigurationRepository;
import cn.featherfly.rc.ConfigurationValue;
import cn.featherfly.rc.SimpleConfiguration;
import cn.featherfly.rc.SimpleConfigurationValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.CachePut;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.transaction.annotation.Transactional;

public class ConfigurationSqlDBRepository
implements ConfigurationRepository {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Hammer hammer;
    private ToStringTypeConversion conversion = new ToStringTypeConversion(ToStringConversionPolicys.getFormatConversionPolicy());
    private static final String CONFIGURATION_DIFINITION_TABLE_NAME = "RC_CONFIGURATION_DIFINITION";
    private static final String CONFIGURATION_VALUE_TABLE_NAME = "RC_CONFIGURATION_VALUE";

    @CachePut(value={"configurationCache"}, key="'config:'+ #configName + ':' + #name")
    @Transactional
    public <V> ConfigurationRepository set(String configName, String name, V value) {
        if (((ExecutableConditionGroupLogicExpression)((ExecutableConditionGroupExpression)((ExecutableConditionGroupLogicExpression)((ExecutableConditionGroupExpression)((ExecutableUpdate)this.hammer.update(CONFIGURATION_VALUE_TABLE_NAME).set("value", value)).where()).eq("config_name", (Object)configName)).and()).eq("name", (Object)name)).execute() < 1) {
            ConfigurationException.throwConfigNotInit((String)configName, (String)name);
        }
        return this;
    }

    public ConfigurationRepository set(String configName, Map<String, Object> configNameValueMap) {
        configNameValueMap.entrySet().forEach(e -> this.set(configName, (String)e.getKey(), e.getValue()));
        return this;
    }

    @Cacheable(value={"configurationCache"}, key="'config:'+ #configName + ':' + #name")
    public <V> V get(String configName, String name, Class<V> type) {
        String valueStr = ((QueryConditionGroupLogicExpression)((QueryConditionGroupExpression)((QueryConditionGroupLogicExpression)((QueryConditionGroupExpression)((QueryEntityProperties)this.hammer.query(CONFIGURATION_VALUE_TABLE_NAME).property("value")).where()).eq("config_name", (Object)configName)).and()).eq("name", (Object)name)).string();
        return (V)this.conversion.targetToSource(valueStr, type);
    }

    public Collection<Configuration> getConfigurations() {
        List configs = ((QuerySortExpression)this.hammer.query(CONFIGURATION_DIFINITION_TABLE_NAME).sort().asc(new String[]{"name"})).list();
        ArrayList<Configuration> configurations = new ArrayList<Configuration>();
        for (Map configMap : configs) {
            configurations.add(this.create(configMap));
        }
        return configurations;
    }

    public Configuration getConfiguration(String name) {
        Map map = ((QueryConditionGroupLogicExpression)((QueryConditionGroupExpression)this.hammer.query(CONFIGURATION_DIFINITION_TABLE_NAME).where()).eq("name", (Object)name)).single();
        return this.create(map);
    }

    private Configuration create(Map<String, Object> configMap) {
        Object objDescp = configMap.get("descp");
        String descp = objDescp == null ? null : objDescp.toString();
        return new SimpleConfiguration(configMap.get("name").toString(), descp, (ConfigurationRepository)this);
    }

    public <C extends Configuration> C getConfiguration(String name, Class<C> type) {
        Configuration configuration = (Configuration)ClassUtils.newInstance(type, (Object[])new Object[]{name, this});
        return (C)configuration;
    }

    public List<ConfigurationValue<?>> getConfigurations(String configName) {
        return ((QuerySortExpression)((QueryConditionGroupLogicExpression)((QueryConditionGroupExpression)this.hammer.query(CONFIGURATION_VALUE_TABLE_NAME).where()).eq("config_name", (Object)configName)).sort().asc(new String[]{"name"})).list(SimpleConfigurationValue.class).stream().map(v -> v).collect(Collectors.toList());
    }

    public List<Map<String, Object>> getConfigValues(String configName) {
        return ((QuerySortExpression)((QueryConditionGroupLogicExpression)((QueryConditionGroupExpression)((QueryEntityProperties)this.hammer.query(CONFIGURATION_VALUE_TABLE_NAME).property(new String[]{"*", "config_name configName"})).where()).co("config_name", configName)).sort().asc(new String[]{"config_name", "name"})).list();
    }

    public Hammer getHammer() {
        return this.hammer;
    }

    public void setHammer(Hammer hammer) {
        this.hammer = hammer;
    }

    public ToStringTypeConversion getConversion() {
        return this.conversion;
    }

    public void setConversion(ToStringTypeConversion conversion) {
        this.conversion = conversion;
    }
}

