/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.rc.persistence;

import cn.featherfly.common.lang.AssertIllegalArgument;
import cn.featherfly.common.lang.ClassUtils;
import cn.featherfly.rc.ConfigurationException;
import cn.featherfly.rc.annotation.ConfigurationDifinition;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.output.FileWriterWithEncoding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.type.classreading.MetadataReader;

public class PropertiesFileConfigurationConfigurator {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Map<String, File> configFileMap = new HashMap<String, File>();
    private static final String DIR_NAME = ".featherfly_configuration";
    private FilePolicy filePolicy = FilePolicy.EACH_FILE_FOR_DEFINE;
    private DirPolicy dirPolicy = DirPolicy.USER_DIR;
    private Set<MetadataReader> metadataReaders = new HashSet<MetadataReader>();
    private File storeDir;
    private String projectName;

    public PropertiesFileConfigurationConfigurator(String projectName, Set<MetadataReader> metadataReaders) {
        this(projectName, FilePolicy.EACH_FILE_FOR_DEFINE, DirPolicy.USER_DIR, metadataReaders);
    }

    public PropertiesFileConfigurationConfigurator(String projectName, FilePolicy filePolicy, DirPolicy dirPolicy, Set<MetadataReader> metadataReaders) {
        AssertIllegalArgument.isNotNull((Object)projectName, (String)"projectName");
        this.projectName = projectName;
        this.filePolicy = filePolicy;
        this.dirPolicy = dirPolicy;
        this.metadataReaders = metadataReaders;
        this.init();
    }

    public void init() {
        if (this.dirPolicy == DirPolicy.USER_DIR) {
            this.storeDir = new File(FileUtils.getUserDirectoryPath() + "/" + DIR_NAME + "/" + this.projectName);
        }
        if (this.filePolicy == FilePolicy.EACH_FILE_FOR_DEFINE) {
            for (MetadataReader metadataReader : this.metadataReaders) {
                if (!metadataReader.getAnnotationMetadata().hasAnnotation(ConfigurationDifinition.class.getName())) continue;
                Class type = ClassUtils.forName((String)metadataReader.getClassMetadata().getClassName());
                String configName = type.getAnnotation(ConfigurationDifinition.class).name();
                String relativePath = ClassUtils.packageToDir((Class)type);
                File file = new File(this.storeDir.getAbsoluteFile() + "/" + relativePath + "/" + type.getSimpleName() + ".properties");
                if (!file.exists()) {
                    this.createFile(file, configName);
                    this.configFileMap.put(configName, file);
                    try {
                        Properties properties = new Properties();
                        properties.setProperty(type.getName(), configName);
                        properties.store((Writer)new FileWriterWithEncoding(file, "UTF-8"), configName);
                        this.logger.debug("create file {} for {}", (Object)file.getAbsolutePath(), (Object)type.getName());
                    }
                    catch (IOException e) {
                        this.logger.error(e.getMessage());
                        ConfigurationException.throwConfigNotInit((String)configName, (String)"*");
                    }
                    continue;
                }
                this.configFileMap.put(configName, file);
            }
        }
    }

    private void createFile(File file, String configName) {
        try {
            FileUtils.write((File)file, (CharSequence)"", (String)"UTF-8");
        }
        catch (IOException e) {
            this.logger.error(e.getMessage());
            ConfigurationException.throwConfigNotInit((String)configName, (String)"*");
        }
    }

    public Set<MetadataReader> getMetadataReaders() {
        return this.metadataReaders;
    }

    public void setMetadataReaders(Set<MetadataReader> metadataReaders) {
        this.metadataReaders = metadataReaders;
    }

    public FilePolicy getFilePolicy() {
        return this.filePolicy;
    }

    public void setFilePolicy(FilePolicy filePolicy) {
        this.filePolicy = filePolicy;
    }

    public DirPolicy getDirPolicy() {
        return this.dirPolicy;
    }

    public void setDirPolicy(DirPolicy dirPolicy) {
        this.dirPolicy = dirPolicy;
    }

    public PropertiesFileConfigurationConfigurator setConfig(String configName, String name, String value) {
        Properties properties = this.loadConfig(configName);
        try {
            properties.setProperty(name, value);
            properties.store((Writer)new FileWriterWithEncoding(this.configFileMap.get(configName), "UTF-8"), configName);
        }
        catch (IOException e) {
            throw new ConfigurationException(String.format("\u4e3a%s\u7684%s\u8bbe\u7f6e\u503c%s\u65f6\u53d1\u751f\u9519\u8bef%s", configName, name, value, e.getMessage()));
        }
        return this;
    }

    public String getConfig(String configName, String name) {
        Properties properties = this.loadConfig(configName);
        return properties.getProperty(name);
    }

    private Properties loadConfig(String configName) {
        File file = this.configFileMap.get(configName);
        if (file == null) {
            throw new ConfigurationException(String.format("%s\u7684\u914d\u7f6e\u6587\u4ef6\u672a\u627e\u5230", configName));
        }
        try {
            Properties properties = new Properties();
            properties.load(new FileReader(file));
            return properties;
        }
        catch (IOException e) {
            throw new ConfigurationException(String.format("\u52a0\u8f7d%s\u7684\u914d\u7f6e\u6587\u4ef6%s\u62a5\u9519", configName, file.getPath()));
        }
    }

    public Set<String> getConfigNames() {
        return this.configFileMap.keySet();
    }

    public static enum DirPolicy {
        USER_DIR;

    }

    public static enum FilePolicy {
        EACH_FILE_FOR_DEFINE;

    }
}

