/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.rc.persistence;

import cn.featherfly.common.lang.ClassUtils;
import cn.featherfly.common.lang.reflect.GenericClass;
import cn.featherfly.conversion.core.ConversionPolicysJdk8;
import cn.featherfly.conversion.core.TypeConversion;
import cn.featherfly.persistence.jdbc.JdbcPersistence;
import cn.featherfly.rc.Configuration;
import cn.featherfly.rc.ConfigurationException;
import cn.featherfly.rc.ConfigurationPersistence;
import cn.featherfly.rc.ConfigurationValuePersistence;
import cn.featherfly.rc.SimpleConfiguration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.CachePut;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.transaction.annotation.Transactional;

public class ConfigurationPersistenceSqlDBImpl
implements ConfigurationPersistence,
ConfigurationValuePersistence {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource(name="jdbcPersistence")
    private JdbcPersistence jdbcPersistence;
    private TypeConversion conversion = new TypeConversion(ConversionPolicysJdk8.getFormatConversionPolicy());
    private static final String CONFIGURATION_DIFINITION_TABLE_NAME = "RC_CONFIGURATION_DIFINITION";
    private static final String CONFIGURATION_VALUE_TABLE_NAME = "RC_CONFIGURATION_VALUE";

    @CachePut(value={"configurationCache"}, key="'config:'+ #configName + ':' + #name")
    @Transactional
    public <V> V set(String configName, String name, V value) {
        String sql = String.format("update %s set value = ? where config_name = ? and name = ?", CONFIGURATION_VALUE_TABLE_NAME);
        if (this.jdbcPersistence.execute(sql, new Object[]{value, configName, name}) < 1) {
            ConfigurationException.throwConfigNotInit((String)configName, (String)name);
        }
        return value;
    }

    @Cacheable(value={"configurationCache"}, key="'config:'+ #configName + ':' + #name")
    public <V> V get(String configName, String name, Class<V> type) {
        String sql = String.format("select value from %s where config_name = ? and name = ?", CONFIGURATION_VALUE_TABLE_NAME);
        String valueStr = this.jdbcPersistence.findForString(sql, new Object[]{configName, name});
        return (V)this.conversion.toObject(valueStr, new GenericClass(type));
    }

    public Collection<Configuration> getConfigurations() {
        String sql = String.format("select name from %s order by NAME", CONFIGURATION_DIFINITION_TABLE_NAME);
        List names = this.jdbcPersistence.findForList(sql, String.class, new Object[0]);
        ArrayList<Configuration> configurations = new ArrayList<Configuration>();
        for (String name : names) {
            configurations.add(this.getConfiguration(name));
        }
        return configurations;
    }

    public Configuration getConfiguration(String name) {
        SimpleConfiguration simpleConfiguration = new SimpleConfiguration(name, (ConfigurationValuePersistence)this);
        return simpleConfiguration;
    }

    public <C extends Configuration> C getConfiguration(String name, Class<C> type) {
        Configuration configuration = (Configuration)ClassUtils.newInstance(type, (Object[])new Object[]{name, this});
        return (C)configuration;
    }

    public List<Map<String, Object>> getConfigurations(String configName) {
        String sql = "select * from rc_configuration_difinition where name like '%" + configName + "%' order by NAME";
        return this.jdbcPersistence.findList(sql);
    }

    public List<Map<String, Object>> getConfigValues(String configName) {
        String sql = "select *,config_name configName from rc_configuration_value where config_name = ? order by config_name, NAME";
        return this.jdbcPersistence.findList(sql, new Object[]{configName});
    }
}

