/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.rc.persistence;

import cn.featherfly.common.lang.ClassUtils;
import cn.featherfly.common.lang.reflect.GenericClass;
import cn.featherfly.conversion.core.ConversionPolicysJdk8;
import cn.featherfly.conversion.core.TypeConversion;
import cn.featherfly.rc.Configuration;
import cn.featherfly.rc.ConfigurationPersistence;
import cn.featherfly.rc.ConfigurationValuePersistence;
import cn.featherfly.rc.SimpleConfiguration;
import cn.featherfly.rc.persistence.PropertiesFileConfigurationConfigurator;
import java.util.ArrayList;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationPersistenceFileImpl
implements ConfigurationPersistence,
ConfigurationValuePersistence {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private PropertiesFileConfigurationConfigurator configurator;
    private TypeConversion conversion;

    public ConfigurationPersistenceFileImpl(PropertiesFileConfigurationConfigurator configurator) {
        this(configurator, new TypeConversion(ConversionPolicysJdk8.getBasicConversionPolicy()));
    }

    public ConfigurationPersistenceFileImpl(PropertiesFileConfigurationConfigurator configurator, TypeConversion conversion) {
        this.configurator = configurator;
        this.conversion = conversion;
    }

    public <V> V set(String configName, String name, V value) {
        this.configurator.setConfig(configName, name, this.conversion.toString(value, new GenericClass(value.getClass())));
        return value;
    }

    public <V> V get(String configName, String name, Class<V> type) {
        String valueStr = this.configurator.getConfig(configName, name);
        return (V)this.conversion.toObject(valueStr, new GenericClass(type));
    }

    public Collection<Configuration> getConfigurations() {
        ArrayList<Configuration> configurations = new ArrayList<Configuration>();
        for (String name : this.configurator.getConfigNames()) {
            configurations.add(this.getConfiguration(name));
        }
        return configurations;
    }

    public Configuration getConfiguration(String name) {
        SimpleConfiguration simpleConfiguration = new SimpleConfiguration(name, (ConfigurationValuePersistence)this);
        return simpleConfiguration;
    }

    public <C extends Configuration> C getConfiguration(String name, Class<C> type) {
        Configuration configuration = (Configuration)ClassUtils.newInstance(type, (Object[])new Object[]{name, this});
        return (C)configuration;
    }
}

