/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.rc.spring;

import cn.featherfly.common.lang.ClassUtils;
import cn.featherfly.common.lang.LangUtils;
import cn.featherfly.rc.ConfigurationException;
import cn.featherfly.rc.annotation.ConfigurationDifinition;
import cn.featherfly.rc.javassist.DynamicConfigurationFacotry;
import java.util.HashSet;
import java.util.Set;
import javassist.CannotCompileException;
import javassist.NotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.core.type.classreading.MetadataReader;

public class DynamicConfigurationSpringRegist
implements BeanDefinitionRegistryPostProcessor {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Set<MetadataReader> metadataReaders = new HashSet<MetadataReader>();
    private DynamicConfigurationFacotry dynamicConfigurationFacotry = DynamicConfigurationFacotry.getInstance();
    private String configurationValuePersistenceReference;

    public DynamicConfigurationSpringRegist(String configurationValuePersistenceReference) {
        this.configurationValuePersistenceReference = configurationValuePersistenceReference;
    }

    public DynamicConfigurationSpringRegist(Set<MetadataReader> metadataReaders, String configurationValuePersistenceReference) {
        this.metadataReaders = metadataReaders;
        this.configurationValuePersistenceReference = configurationValuePersistenceReference;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
    }

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        if (LangUtils.isEmpty(this.metadataReaders)) {
            this.logger.debug("metadataReaders is empty");
        }
        this.logger.debug("start regist configuration to spring");
        for (MetadataReader metadataReader : this.metadataReaders) {
            if (!metadataReader.getAnnotationMetadata().hasAnnotation(ConfigurationDifinition.class.getName())) continue;
            try {
                Class type = ClassUtils.forName((String)metadataReader.getClassMetadata().getClassName());
                String configName = type.getAnnotation(ConfigurationDifinition.class).name();
                String dynamicImplName = this.dynamicConfigurationFacotry.create(type);
                this.logger.debug("create class {} for {}", (Object)dynamicImplName, (Object)type.getName());
                this.logger.debug("regist -> {} for config named {}", (Object)dynamicImplName, (Object)configName);
                BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition((Class)ClassUtils.forName((String)dynamicImplName));
                builder.addConstructorArgValue((Object)configName);
                builder.addConstructorArgReference(this.configurationValuePersistenceReference);
                builder.setScope("singleton");
                registry.registerBeanDefinition(configName, (BeanDefinition)builder.getBeanDefinition());
            }
            catch (CannotCompileException | NotFoundException e) {
                throw new ConfigurationException(e);
            }
        }
        this.logger.debug("end regist configuration to spring");
    }

    public Set<MetadataReader> getMetadataReaders() {
        return this.metadataReaders;
    }

    public void setMetadataReaders(Set<MetadataReader> metadataReaders) {
        this.metadataReaders = metadataReaders;
    }
}

